/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GFRegistry;
import greekfantasy.entity.Orthus;
import greekfantasy.entity.ai.ShootFireGoal;
import greekfantasy.entity.ai.SummonMobGoal;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Cerberus
extends PathfinderMob
implements Enemy {
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(Cerberus.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final String KEY_STATE = "CerberusState";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte FIRING = 2;
    private static final byte SUMMONING = 4;
    private static final double FIRE_RANGE = 6.0;
    private static final int MAX_SPAWN_TIME = 90;
    private static final int MAX_FIRING_TIME = 66;
    private static final int MAX_SUMMON_TIME = 35;
    private static final byte SPAWN_CLIENT = 9;
    private static final byte SUMMON_CLIENT = 10;
    private int spawnTime0;
    private int spawnTime;
    private int summonTime0;
    private int summonTime;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public Cerberus(EntityType<? extends Cerberus> type, Level level) {
        super(type, level);
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 190.0).add(Attributes.MOVEMENT_SPEED, 0.3125).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    public static Cerberus spawnCerberus(Level level, Vec3 pos) {
        Cerberus entity = (Cerberus)((EntityType)GFRegistry.EntityReg.CERBERUS.get()).create(level);
        entity.moveTo(pos.x(), pos.y(), pos.z(), 0.0f, 0.0f);
        entity.yBodyRot = 0.0f;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.addFreshEntityWithPassengers((Entity)entity);
            entity.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z)), MobSpawnType.MOB_SUMMONED, null);
            for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(25.0))) {
                CriteriaTriggers.SUMMONED_ENTITY.trigger(player, (Entity)entity);
            }
        }
        entity.setSpawning(true);
        entity.playSound(SoundEvents.WITHER_SPAWN, 1.2f, 1.0f);
        return entity;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SpawningGoal());
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new FireAttackGoal(66, 120));
        this.goalSelector.addGoal(2, (Goal)new SummonOrthusGoal(35, 310, 300));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.6f));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        this.spawnTime0 = this.spawnTime--;
        if (this.isSpawning()) {
            if (this.spawnTime <= 0) {
                this.setSpawning(false);
            }
            this.addSpawningParticles((ParticleOptions)ParticleTypes.FLAME, 4);
            this.addSpawningParticles((ParticleOptions)ParticleTypes.SMOKE, 1);
            this.addSpawningParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, 1);
        }
        this.summonTime0 = this.summonTime++;
        if (!this.isSummoning() && this.summonTime > 0) {
            this.summonTime = 0;
        }
        if (this.isEffectiveAi() && this.isFiring() && this.getTarget() == null) {
            this.setFiring(false);
        }
        if (this.level().isClientSide() && this.isFiring()) {
            this.spawnFireParticles();
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficulty, mobSpawnType, spawnDataIn);
        this.setSpawning(true);
        return result;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return this.isSpawning() || source == this.damageSources().inWall() || source.is(DamageTypeTags.WITHER_IMMUNE_TO) || super.isInvulnerableTo(source);
    }

    public void push(Entity entity) {
        if (this.isPushable() && !this.isSpawning()) {
            super.push(entity);
        }
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.MONSTER;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WOLF_GROWL;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.WOLF_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WOLF_DEATH;
    }

    protected float getSoundVolume() {
        return 1.2f;
    }

    public float getVoicePitch() {
        return 0.4f + this.random.nextFloat() * 0.2f;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 0.6f);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getCustomName());
        }
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_STATE, this.getCerberusState());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setCerberusState(compound.getByte(KEY_STATE));
    }

    public byte getCerberusState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public void setCerberusState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getCerberusState() == 0;
    }

    public boolean isFiring() {
        return this.getCerberusState() == 2;
    }

    public void setFiring(boolean firing) {
        this.setCerberusState(firing ? (byte)2 : 0);
    }

    public boolean isSummoning() {
        return this.getCerberusState() == 4;
    }

    public void setSummoning(boolean summoning) {
        this.setCerberusState(summoning ? (byte)4 : 0);
        int n = this.summonTime = summoning ? 1 : 0;
        if (summoning && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)10);
        }
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getCerberusState() == 1;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 90 : 0;
        this.setCerberusState(spawning ? (byte)1 : 0);
        if (spawning && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)9);
        }
    }

    public float getSpawnPercent(float partialTick) {
        return 1.0f - Mth.lerp((float)partialTick, (float)this.spawnTime0, (float)this.spawnTime) / 90.0f;
    }

    public float getSummonPercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.summonTime0, (float)this.summonTime) / 35.0f;
    }

    public void spawnFireParticles() {
        if (!this.level().isClientSide()) {
            return;
        }
        Vec3 lookVec = this.getLookAngle();
        Vec3 pos = this.getEyePosition(1.0f);
        double motion = 0.06;
        double radius = 0.75;
        for (int i = 0; i < 5; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, pos.x + (this.level().random.nextDouble() - 0.5) * 0.75, pos.y + (this.level().random.nextDouble() - 0.5) * 0.75, pos.z + (this.level().random.nextDouble() - 0.5) * 0.75, lookVec.x * 0.06 * 6.0, lookVec.y * 0.06 * 0.5, lookVec.z * 0.06 * 6.0);
        }
    }

    private void addSpawningParticles(ParticleOptions particle, int count) {
        if (!this.level().isClientSide()) {
            return;
        }
        double x = this.getX();
        double y = this.getY() + 0.1;
        double z = this.getZ();
        double motion = 0.08;
        double radius = this.getBbWidth();
        for (int i = 0; i < count; ++i) {
            this.level().addParticle(particle, x + (this.level().random.nextDouble() - 0.5) * radius, y + (this.level().random.nextDouble() - 0.5) * radius, z + (this.level().random.nextDouble() - 0.5) * radius, (this.level().random.nextDouble() - 0.5) * 0.08, 0.15, (this.level().random.nextDouble() - 0.5) * 0.08);
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 9: {
                this.setSpawning(true);
                break;
            }
            case 10: {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.WOLF_HOWL, this.getSoundSource(), 1.1f, 0.9f + this.getRandom().nextFloat() * 0.2f, false);
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.setFlags(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean canUse() {
            return Cerberus.this.isSpawning();
        }

        public void tick() {
            Cerberus.this.getNavigation().stop();
            Cerberus.this.setTarget(null);
        }
    }

    class FireAttackGoal
    extends ShootFireGoal {
        protected FireAttackGoal(int fireTimeIn, int maxCooldownIn) {
            super((Mob)Cerberus.this, fireTimeIn, maxCooldownIn, 6.0);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && Cerberus.this.isNoneState();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && Cerberus.this.isFiring();
        }

        @Override
        public void start() {
            super.start();
            Cerberus.this.setFiring(true);
        }

        @Override
        public void stop() {
            super.stop();
            Cerberus.this.setFiring(false);
        }
    }

    class SummonOrthusGoal
    extends SummonMobGoal<Orthus> {
        private final int lifespan;

        public SummonOrthusGoal(int summonProgressIn, int summonCooldownIn, int lifespanIn) {
            super(Cerberus.this, summonProgressIn, summonCooldownIn, (EntityType)GFRegistry.EntityReg.ORTHUS.get());
            this.lifespan = lifespanIn;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && Cerberus.this.isNoneState();
        }

        @Override
        public void start() {
            super.start();
            Cerberus.this.setSummoning(true);
        }

        @Override
        public void stop() {
            super.stop();
            Cerberus.this.setSummoning(false);
        }

        @Override
        public void tick() {
            super.tick();
            if (this.progressTimer == 8) {
                Cerberus.this.level().broadcastEntityEvent((Entity)Cerberus.this, (byte)10);
            }
        }

        @Override
        protected void onSummonMob(Orthus mobEntity) {
            mobEntity.setLimitedLife(this.lifespan);
        }
    }
}

