/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.Whirl;
import greekfantasy.entity.boss.Scylla;
import greekfantasy.entity.misc.WaterSpell;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Charybdis
extends WaterAnimal
implements Enemy {
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(Charybdis.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final String KEY_STATE = "CharybdisState";
    private static final String KEY_SPAWN_TIME = "SpawnTime";
    private static final String KEY_SWIRL_TIME = "SwirlTime";
    private static final String KEY_THROW_TIME = "ThrowTime";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte SWIRLING = 2;
    private static final byte THROWING = 4;
    private static final byte NONE_CLIENT = 8;
    private static final byte SPAWN_CLIENT = 9;
    private static final byte SWIRL_CLIENT = 10;
    private static final byte THROW_CLIENT = 11;
    private static final double RANGE = 15.0;
    private static final int SPAWN_TIME = 50;
    private static final int SWIRL_TIME = 240;
    private static final int THROW_TIME = 34;
    protected static final Predicate<Entity> CAN_TARGET = e -> {
        Player p;
        return e.isInWaterOrBubble() && !e.isSpectator() && (!(e instanceof Player) || !(p = (Player)e).isCreative()) && e.getType() != GFRegistry.EntityReg.SCYLLA.get() && (e.getType() != GFRegistry.EntityReg.WHIRL.get() || !(e instanceof LivingEntity) && !(e instanceof Boat) && !(e instanceof ItemEntity));
    };
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    private int spawnTime0;
    private int spawnTime;
    private int swirlTime0;
    private int swirlTime;
    private int throwTime0;
    private int throwTime;

    public Charybdis(EntityType<? extends Charybdis> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 50;
    }

    public static Charybdis spawnCharybdis(ServerLevel level, Whirl whirl) {
        Charybdis entity = (Charybdis)((EntityType)GFRegistry.EntityReg.CHARYBDIS.get()).create((Level)level);
        entity.moveTo(whirl.getX(), whirl.getY() - 2.8, whirl.getZ(), whirl.getYRot(), whirl.getXRot());
        if (whirl.hasCustomName()) {
            entity.setCustomName(whirl.getCustomName());
            entity.setCustomNameVisible(whirl.isCustomNameVisible());
        }
        entity.setPersistenceRequired();
        entity.yBodyRot = whirl.yBodyRot;
        entity.setPortalCooldown();
        level.addFreshEntityWithPassengers((Entity)entity);
        entity.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(whirl.blockPosition()), MobSpawnType.CONVERSION, null);
        entity.setState((byte)1);
        whirl.discard();
        for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(16.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(player, (Entity)entity);
        }
        entity.playSound(SoundEvents.WITHER_SPAWN, 1.2f, 1.0f);
        if ((double)(level.getRandom().nextFloat() * 100.0f) < (Double)GreekFantasy.CONFIG.SCYLLA_SPAWN_CHANCE.get()) {
            Scylla scylla = entity.spawnScylla(level);
        }
        return entity;
    }

    protected Scylla spawnScylla(ServerLevel level) {
        Scylla entity = (Scylla)((EntityType)GFRegistry.EntityReg.SCYLLA.get()).create((Level)level);
        BlockPos entityPos = new BlockPos((int)this.position().x, (int)this.position().y, (int)this.position().z);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        int radius = Mth.ceil((float)(this.getBbWidth() * 1.5f));
        int maxTries = 24;
        for (int tries = 0; tries < maxTries; ++tries) {
            blockPos.setWithOffset((Vec3i)entityPos, level.getRandom().nextInt(radius * 2) - radius, level.getRandom().nextInt(4) - 2, level.getRandom().nextInt(radius * 2) - radius);
            AABB aabb = ((EntityType)GFRegistry.EntityReg.SCYLLA.get()).getDimensions().makeBoundingBox((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
            if (!level.isWaterAt((BlockPos)blockPos) || !level.noCollision((Entity)entity, aabb)) continue;
            entity.moveTo(blockPos.getX(), blockPos.getY(), blockPos.getZ(), 0.0f, 0.0f);
            entity.setPersistenceRequired();
            entity.setPortalCooldown();
            level.addFreshEntityWithPassengers((Entity)entity);
            entity.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt((BlockPos)blockPos), MobSpawnType.MOB_SUMMONED, null);
            entity.playSound(SoundEvents.GHAST_SCREAM, 1.2f, 1.0f);
            return entity;
        }
        entity.discard();
        return null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 180.0).add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ARMOR, 10.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SwirlGoal(this, 240, 90, 15.0));
        this.goalSelector.addGoal(3, (Goal)new ThrowGoal(this, 34, 130, 11.25));
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        if (this.isInWater()) {
            this.setAirSupply(i);
        }
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        this.spawnTime0 = this.spawnTime;
        if (this.isSpawning()) {
            this.spawnTime = Math.max(this.spawnTime - 1, 0);
            if (this.spawnTime <= 0) {
                this.setState((byte)0);
            }
        }
        this.swirlTime0 = this.swirlTime;
        if (this.isSwirling()) {
            this.swirlTime = Math.min(this.swirlTime + 1, 240);
            this.setYBodyRot(this.yBodyRot + 5.0f);
        } else if (this.swirlTime > 0) {
            --this.swirlTime;
        }
        this.throwTime0 = this.throwTime;
        if (this.isThrowing()) {
            this.throwTime = Math.min(this.throwTime + 1, 34);
        } else if (this.throwTime > 0) {
            --this.throwTime;
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && this.tickCount % 3 == 0 && this.isInWaterOrBubble()) {
            this.getEntitiesInRange(15.0).forEach(e -> this.bubbles(e.getX(), e.getY(), e.getZ(), e.getBbWidth(), 5));
            float spawnPercent = this.getSpawnPercent(0.0f);
            float maxY = this.getBbHeight() * spawnPercent * 1.65f;
            float y = 0.0f;
            float nY = 120.0f * spawnPercent;
            float dY = maxY / nY;
            double posX = this.getX();
            double posY = this.getY();
            double posZ = this.getZ();
            float a = 0.0f;
            float nA = 28 + this.random.nextInt(4);
            float dA = (float)Math.PI * 2 / nA;
            while (y < maxY) {
                float radius = y * 0.5f;
                float cosA = Mth.cos((float)a) * radius;
                float sinA = Mth.sin((float)a) * radius;
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, posX + (double)cosA, posY + (double)y - (double)maxY * 0.4, posZ + (double)sinA, 0.0, 0.085, 0.0);
                y += dY;
                a += dA;
            }
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(level, difficulty, spawnType, spawnDataIn);
        this.setState((byte)1);
        return result;
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.MONSTER;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public boolean removeWhenFarAway(double disToPlayer) {
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return this.isSpawning() || source == this.damageSources().inWall() || source.is(DamageTypeTags.WITHER_IMMUNE_TO) || source.getDirectEntity() instanceof AbstractArrow || source.getDirectEntity() instanceof WaterSpell || super.isInvulnerableTo(source);
    }

    protected void handleAirSupply(int air) {
    }

    public double getFluidJumpThreshold() {
        return (double)this.getBbHeight() - 0.2;
    }

    protected float getWaterSlowDown() {
        return 0.89f;
    }

    public boolean isPushable() {
        return false;
    }

    protected void pushEntities() {
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.HOSTILE_SPLASH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ELDER_GUARDIAN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ELDER_GUARDIAN_DEATH;
    }

    protected float getSoundVolume() {
        return 1.4f;
    }

    public float getVoicePitch() {
        return 0.6f + this.random.nextFloat() * 0.2f;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_STATE, this.getState());
        compound.putInt(KEY_SPAWN_TIME, this.spawnTime);
        compound.putInt(KEY_SWIRL_TIME, this.swirlTime);
        compound.putInt(KEY_THROW_TIME, this.throwTime);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setState(compound.getByte(KEY_STATE));
        this.spawnTime0 = this.spawnTime = compound.getInt(KEY_SPAWN_TIME);
        this.swirlTime0 = this.swirlTime = compound.getInt(KEY_SWIRL_TIME);
        this.throwTime0 = this.throwTime = compound.getInt(KEY_THROW_TIME);
    }

    public void travel(Vec3 vec) {
        if (this.isEffectiveAi() && this.isInWater() && !this.isEyeInFluid(FluidTags.WATER)) {
            this.moveRelative(-0.02f, vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(vec);
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void setState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
        byte clientFlag = 8;
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                this.spawnTime = 50;
                clientFlag = 9;
                break;
            }
            case 2: {
                clientFlag = 10;
                break;
            }
            case 4: {
                clientFlag = 11;
            }
        }
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, clientFlag);
        }
    }

    public byte getState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public boolean isNoneState() {
        return this.getState() == 0;
    }

    public boolean isSpawning() {
        return this.getState() == 1;
    }

    public boolean isSwirling() {
        return this.getState() == 2;
    }

    public boolean isThrowing() {
        return this.getState() == 4;
    }

    public float getSpawnPercent(float partialTick) {
        return 1.0f - Mth.lerp((float)partialTick, (float)this.spawnTime0, (float)this.spawnTime) / 50.0f;
    }

    public float getSwirlPercent(float partialTick) {
        return Mth.clamp((float)(Mth.lerp((float)partialTick, (float)this.swirlTime0, (float)this.swirlTime) / 50.0f), (float)0.0f, (float)1.0f);
    }

    public float getThrowPercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.throwTime0, (float)this.throwTime) / 34.0f;
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 0: {
                this.setState((byte)0);
                break;
            }
            case 9: {
                this.setState((byte)1);
                break;
            }
            case 10: {
                this.setState((byte)2);
                break;
            }
            case 11: {
                this.setState((byte)4);
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public List<Entity> getEntitiesInRange(double range) {
        return this.level().getEntities((Entity)this, this.getBoundingBox().inflate(range, range / 2.0, range), CAN_TARGET);
    }

    public void bubbles(double posX, double posY, double posZ, double radius, int count) {
        double motion = 0.08;
        for (int i = 0; i < count; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, posX + (this.level().random.nextDouble() - 0.5) * radius, posY, posZ + (this.level().random.nextDouble() - 0.5) * radius, (this.level().random.nextDouble() - 0.5) * 0.08, 0.5, (this.level().random.nextDouble() - 0.5) * 0.08);
        }
    }

    private static class SwirlGoal
    extends greekfantasy.entity.ai.SwirlGoal {
        private final Charybdis entity;

        public SwirlGoal(Charybdis entity, int duration, int cooldown, double range) {
            super((LivingEntity)entity, duration, cooldown, range, 0.12f, true, e -> e.getType() != GFRegistry.EntityReg.WHIRL.get() && e.getType() != GFRegistry.EntityReg.CHARYBDIS.get() && e.getType() != GFRegistry.EntityReg.SCYLLA.get());
            this.entity = entity;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && (this.entity.isNoneState() || this.entity.isSwirling());
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.entity.isSwirling();
        }

        @Override
        public void start() {
            super.start();
            this.entity.setState((byte)2);
        }

        @Override
        public void tick() {
            super.tick();
            float attack = (float)this.entity.getAttribute(Attributes.ATTACK_DAMAGE).getValue() * 0.25f;
            for (Entity e : this.trackedEntities) {
                if (!(e instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)e;
                livingEntity.addEffect(new MobEffectInstance(GFRegistry.MobEffectReg.SLOW_SWIM, 10, 0));
                if (livingEntity.hurtTime != 0 || livingEntity.tickCount % 20 != 0) continue;
                livingEntity.hurt(livingEntity.damageSources().mobAttack((LivingEntity)this.entity), attack);
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.entity.setState((byte)0);
        }

        @Override
        protected void onCollideWith(Entity e) {
            float attack = (float)this.entity.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
            if (e.hurt(e.damageSources().mobAttack((LivingEntity)this.entity), attack)) {
                this.entity.heal(Math.abs(attack * 0.25f));
            }
        }
    }

    class ThrowGoal
    extends Goal {
        protected final Charybdis entity;
        protected final int duration;
        protected final int cooldown;
        protected final double range;
        protected List<Entity> trackedEntities = new ArrayList<Entity>();
        protected int progressTime;
        protected int cooldownTime;

        public ThrowGoal(Charybdis this$0, int lDuration, int lCooldown, double lRange) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.entity = this$0;
            this.duration = lDuration;
            this.cooldown = lCooldown;
            this.range = lRange;
            this.cooldownTime = 50;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean canUse() {
            if (this.cooldownTime > 0) {
                --this.cooldownTime;
            } else if (this.entity.isNoneState() || this.entity.isThrowing()) {
                this.trackedEntities = this.entity.getEntitiesInRange(this.range);
                return this.trackedEntities.size() > 0;
            }
            return false;
        }

        public void start() {
            this.entity.setState((byte)4);
            this.entity.throwTime = 1;
            this.progressTime = 1;
        }

        public boolean canContinueToUse() {
            return this.progressTime > 0 && this.entity.isThrowing();
        }

        public void tick() {
            if (this.progressTime++ >= this.duration) {
                double widthSq = this.entity.getBbWidth() * this.entity.getBbWidth();
                this.trackedEntities = this.entity.getEntitiesInRange(this.range);
                for (Entity target : this.trackedEntities) {
                    double dz;
                    double dx = this.entity.getX() - target.position().x;
                    double horizDisSq = dx * dx + (dz = this.entity.getZ() - target.position().z) * dz;
                    if (!(horizDisSq > widthSq)) continue;
                    double motion = 1.08 + 0.31 * (1.0 - horizDisSq / (this.range * this.range));
                    target.push(0.0, motion, 0.0);
                    target.hurtMarked = true;
                    if (!(target instanceof Boat) && target.getPassengers().isEmpty()) continue;
                    target.hurt(target.damageSources().mobAttack((LivingEntity)this.entity), 6.0f);
                }
                this.stop();
            }
        }

        public void stop() {
            this.entity.setState((byte)0);
            this.entity.throwTime = 0;
            this.progressTime = 0;
            this.cooldownTime = this.cooldown;
            this.trackedEntities.clear();
        }
    }
}

