/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.IntervalRangedAttackGoal;
import greekfantasy.entity.ai.SummonMobGoal;
import greekfantasy.entity.misc.ThrowingAxe;
import greekfantasy.entity.monster.Minotaur;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class CretanMinotaur
extends Minotaur
implements RangedAttackMob {
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);

    public CretanMinotaur(EntityType<? extends CretanMinotaur> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 114.0).add(Attributes.MOVEMENT_SPEED, 0.31).add(Attributes.ATTACK_DAMAGE, 9.0).add(Attributes.ATTACK_KNOCKBACK, 1.5).add(Attributes.ARMOR, 10.0);
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
    }

    @Override
    protected void registerChargeGoal() {
        this.goalSelector.addGoal(2, (Goal)new MinotaurRangedAttackGoal(this, 5, 1, 95));
        this.goalSelector.addGoal(3, (Goal)new MinotaurSummonMobGoal(this, 10, 130, 1));
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (!this.level().isClientSide() && this.tickCount % 60 == 1) {
            this.bossInfo.removeAllPlayers();
            List serverPlayers = this.level().getEntitiesOfClass(ServerPlayer.class, this.getBoundingBox().inflate(24.0));
            for (ServerPlayer player : serverPlayers) {
                if (player == null || !this.getSensing().hasLineOfSight((Entity)player)) continue;
                this.bossInfo.addPlayer(player);
            }
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource randomSource, DifficultyInstance difficulty) {
        ItemStack axe = new ItemStack((ItemLike)GFRegistry.ItemReg.THROWING_AXE.get());
        this.setItemInHand(InteractionHand.MAIN_HAND, axe);
        this.setDropChance(EquipmentSlot.MAINHAND, 0.8f);
    }

    protected void populateDefaultEquipmentEnchantments(RandomSource randomSource, DifficultyInstance difficulty) {
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.populateDefaultEquipmentSlots(this.getRandom(), difficultyIn);
        this.populateDefaultEquipmentEnchantments(this.getRandom(), difficultyIn);
        return result;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.setVisible(GreekFantasy.CONFIG.showCretanBossBar());
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getCustomName());
        }
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    @Override
    protected float getSoundVolume() {
        return 1.2f;
    }

    public float getVoicePitch() {
        return super.getVoicePitch() - 0.2f;
    }

    public int getAmbientSoundInterval() {
        return 240;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (!this.level().isClientSide()) {
            ItemStack axe = this.getMainHandItem().copy();
            ThrowingAxe throwingAxe = new ThrowingAxe(this.level(), (LivingEntity)this, axe, false);
            throwingAxe.setBaseDamage(throwingAxe.getBaseDamage() + this.getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.5);
            double dx = target.getX() - throwingAxe.getX();
            double dy = target.getY(0.67) - throwingAxe.getY();
            double dz = target.getZ() - throwingAxe.getZ();
            double dis = Math.sqrt(dx * dx + dz * dz);
            throwingAxe.shoot(dx, dy + dis * (double)0.08f, dz, 1.12f, 8 - this.level().getDifficulty().getId());
            this.level().addFreshEntity((Entity)throwingAxe);
        }
        this.swing(InteractionHand.MAIN_HAND);
        this.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 1.2f, 1.2f + this.random.nextFloat() * 0.2f);
    }

    static class MinotaurRangedAttackGoal
    extends IntervalRangedAttackGoal<CretanMinotaur> {
        protected final CretanMinotaur entity;

        public MinotaurRangedAttackGoal(CretanMinotaur mob, int attackInterval, int count, int maxCooldown) {
            super(mob, attackInterval, count, maxCooldown, 12.0f);
            this.entity = mob;
        }

        @Override
        public boolean canUse() {
            return this.entity.isNoneState() && super.canUse();
        }
    }

    static class MinotaurSummonMobGoal
    extends SummonMobGoal<Minotaur> {
        protected final CretanMinotaur entity;

        public MinotaurSummonMobGoal(CretanMinotaur entity, int duration, int cooldown, int mobCount) {
            super((PathfinderMob)entity, duration, cooldown, (EntityType)GFRegistry.EntityReg.MINOTAUR.get(), mobCount);
            this.entity = entity;
        }

        @Override
        public boolean canUse() {
            return this.entity.isNoneState() && super.canUse() && this.entity.getHealth() / this.entity.getMaxHealth() < 0.5f;
        }
    }
}

