/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.CooldownMeleeAttackGoal;
import greekfantasy.entity.ai.SummonMobGoal;
import greekfantasy.entity.monster.MadCow;
import greekfantasy.entity.util.HasCustomCooldown;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class Geryon
extends Monster
implements HasCustomCooldown {
    private static final TagKey<EntityType<?>> BOSSES = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"bosses"));
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(Geryon.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte SMASH = 2;
    private static final byte SUMMON_COW = 4;
    private static final byte START_SPAWN_EVENT = 9;
    private static final byte SMASH_EVENT = 10;
    private static final byte SUMMON_EVENT = 11;
    private static final int MAX_SPAWN_TIME = 110;
    private static final int MAX_SMASH_TIME = 42;
    private static final int MAX_SUMMON_TIME = 35;
    private static final double SMASH_RANGE = 12.0;
    private static final int ATTACK_COOLDOWN = 38;
    private static final int STUN_DURATION = 50;
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private int spawnTime;
    private int smashTime;
    private int summonTime0;
    private int summonTime;
    private int attackCooldown;

    public Geryon(EntityType<? extends Geryon> type, Level level) {
        super(type, level);
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 210.0).add(Attributes.MOVEMENT_SPEED, 0.24).add(Attributes.KNOCKBACK_RESISTANCE, 0.98).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_KNOCKBACK, 1.5).add(Attributes.ARMOR, 12.0).add(Attributes.STEP_HEIGHT, (double)0.6f);
    }

    public static boolean canGeryonSpawnOn(LevelAccessor level, BlockPos pos) {
        AABB box = new AABB(pos).expandTowards(-1.0, 0.0, -1.0).expandTowards(1.0, 5.0, 1.0);
        BlockPos.MutableBlockPos p = pos.mutable();
        for (double x = box.minX; x < box.maxX; x += 1.0) {
            for (double y = box.minY; y < box.maxY; y += 1.0) {
                for (double z = box.minZ; z < box.maxZ; z += 1.0) {
                    p.set(x, y, z);
                    if (!level.getBlockState((BlockPos)p).is(BlockTags.WITHER_IMMUNE)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static Geryon spawnGeryon(Level level, BlockPos pos, float yaw) {
        Geryon entity = (Geryon)((EntityType)GFRegistry.EntityReg.GERYON.get()).create(level);
        entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, yaw, 0.0f);
        entity.yBodyRot = yaw;
        entity.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)GFRegistry.ItemReg.IRON_CLUB.get()));
        level.addFreshEntity((Entity)entity);
        entity.setSpawning(true);
        for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(25.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(player, (Entity)entity);
        }
        entity.playSound(SoundEvents.WITHER_SPAWN, 1.2f, 1.0f);
        return entity;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new SpawningGoal());
        this.goalSelector.addGoal(1, (Goal)new SummonCowGoal(35, 390));
        this.goalSelector.addGoal(2, (Goal)new SmashAttackGoal(12.0, 210));
        this.goalSelector.addGoal(3, (Goal)new GeryonAttackGoal(this, 1.0, false, 38));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (!this.level().isClientSide()) {
            this.tickCustomCooldown();
        }
        if (this.isSpawning() && --this.spawnTime <= 0) {
            this.setSpawning(false);
            if (!this.level().isClientSide()) {
                this.destroyIntersectingBlocks(0.0);
            }
        }
        if (this.isSmashAttack()) {
            ++this.smashTime;
        } else if (this.smashTime > 0) {
            this.smashTime = 0;
        }
        this.summonTime0 = this.summonTime++;
        if (this.isSummoning()) {
            if (this.getItemInHand(InteractionHand.OFF_HAND).isEmpty()) {
                this.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)GFRegistry.ItemReg.HORN.get()));
            }
        } else if (this.summonTime > 0 && --this.summonTime <= 0 && this.getItemInHand(InteractionHand.OFF_HAND).is((Item)GFRegistry.ItemReg.HORN.get())) {
            this.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            if (this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0) {
                this.addBlockParticles(2);
            }
            if (this.isSpawning()) {
                this.addBlockParticles(10);
            }
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            double knockbackFactor = 0.42;
            Vec3 myPos = this.position();
            Vec3 ePos = entityIn.position();
            double dX = Math.signum(ePos.x - myPos.x) * 0.42;
            double dZ = Math.signum(ePos.z - myPos.z) * 0.42;
            entityIn.push(dX, 0.21, dZ);
            entityIn.hurtMarked = true;
            return true;
        }
        return false;
    }

    protected float getJumpPower() {
        return 1.4f * super.getJumpPower();
    }

    public boolean isPushable() {
        return false;
    }

    protected void pushEntities() {
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public boolean removeWhenFarAway(double disToPlayer) {
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getCustomName());
        }
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return this.isSpawning() || source == this.damageSources().inWall() || source.is(DamageTypeTags.WITHER_IMMUNE_TO) || source.getDirectEntity() instanceof AbstractArrow || super.isInvulnerableTo(source);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficulty, spawnType, spawnDataIn);
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)GFRegistry.ItemReg.IRON_CLUB.get()));
        this.setSpawning(true);
        return result;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.VILLAGER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.VILLAGER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.VILLAGER_DEATH;
    }

    protected float getSoundVolume() {
        return 1.5f;
    }

    public float getVoicePitch() {
        return 0.089f;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.saveCustomCooldown(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readCustomCooldown(compound);
    }

    public byte getGeryonState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public void setGeryonState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getGeryonState() == 0;
    }

    public boolean isSmashAttack() {
        return this.getGeryonState() == 2;
    }

    public void setSmashAttack(boolean smash) {
        this.setGeryonState(smash ? (byte)2 : 0);
    }

    public boolean isSummoning() {
        return this.getGeryonState() == 4;
    }

    public void setSummoning(boolean summon) {
        this.setGeryonState(summon ? (byte)4 : 0);
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getGeryonState() == 1;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 110 : 0;
        this.setGeryonState(spawning ? (byte)1 : 0);
        if (spawning && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)9);
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 9: {
                this.setSpawning(true);
                break;
            }
            case 10: {
                List targets = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(12.0, 6.0, 12.0));
                for (Entity e : targets) {
                    this.addSmashParticlesAt(e);
                }
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.IRON_GOLEM_ATTACK, this.getSoundSource(), 2.0f, 0.4f, false);
                this.addBlockParticles(45);
                break;
            }
            case 11: {
                int i;
                for (i = 0; i < 4; ++i) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_DIDGERIDOO.value(), this.getSoundSource(), 2.0f, 0.2f, false);
                }
                for (i = 0; i < 2; ++i) {
                    this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_DIDGERIDOO.value(), this.getSoundSource(), 1.8f, 0.4f, false);
                }
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    private void addBlockParticles(int count) {
        int i = Mth.floor((double)this.getX());
        int j = Mth.floor((double)(this.getY() - (double)0.2f));
        int k = Mth.floor((double)this.getZ());
        BlockPos pos = new BlockPos(i, j, k);
        BlockState blockstate = this.level().getBlockState(pos);
        if (!blockstate.isAir()) {
            BlockParticleOption data = new BlockParticleOption(ParticleTypes.BLOCK, blockstate).setPos(pos);
            double radius = this.getBbWidth();
            double motion = 4.0;
            for (int c = 0; c < count; ++c) {
                this.level().addParticle((ParticleOptions)data, this.getX() + (this.random.nextDouble() - 0.5) * radius * 2.0, this.getY() + 0.1, this.getZ() + (this.random.nextDouble() - 0.5) * radius * 2.0, 4.0 * (this.random.nextDouble() - 0.5), 0.5, (this.random.nextDouble() - 0.5) * 4.0);
            }
        }
    }

    private void addSmashParticlesAt(Entity e) {
        double x = e.getX() + 0.5;
        double y = e.getY() + 0.1;
        double z = e.getZ() + 0.5;
        double motion = 0.08;
        double radius = e.getBbWidth();
        for (int i = 0; i < 25; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, x + (this.level().random.nextDouble() - 0.5) * radius, y, z + (this.level().random.nextDouble() - 0.5) * radius, (this.level().random.nextDouble() - 0.5) * 0.08, 0.5, (this.level().random.nextDouble() - 0.5) * 0.08);
        }
    }

    public float getSmashPercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)Math.max(0.0f, (float)(this.smashTime - 1)), (float)this.smashTime) / 42.0f;
    }

    public float getSpawnPercent(float partialTick) {
        return 1.0f - Mth.lerp((float)partialTick, (float)Math.max(0.0f, (float)(this.spawnTime - 1)), (float)this.spawnTime) / 110.0f;
    }

    public float getSummonPercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.summonTime0, (float)this.summonTime) / 35.0f;
    }

    private boolean isExemptFromSmashAttack(Entity entity) {
        Player player;
        return !entity.canChangeDimensions(entity.level(), entity.level()) || entity.getType().is(BOSSES) || entity.isNoGravity() || entity.getType() == this.getType() || entity.getType() == GFRegistry.EntityReg.MAD_COW.get() || entity.isSpectator() || entity instanceof Player && (player = (Player)entity).isCreative();
    }

    private void useSmashAttack(Entity entity) {
        if (entity.onGround() && !this.isExemptFromSmashAttack(entity)) {
            entity.push(0.0, 0.65, 0.0);
            entity.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
            if (entity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                if (((Boolean)GreekFantasy.CONFIG.STUNNED_NERF.get()).booleanValue()) {
                    target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 50, 0));
                    target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 50, 0));
                } else {
                    target.addEffect(new MobEffectInstance(GFRegistry.MobEffectReg.STUNNED, 50, 0));
                }
            }
        }
    }

    private void destroyIntersectingBlocks(double offset) {
        if (!this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return;
        }
        Vec3 facing = Vec3.directionFromRotation((Vec2)this.getRotationVector());
        AABB box = this.getBoundingBox().move(facing.normalize().scale(offset));
        BlockPos.betweenClosedStream((AABB)box).forEach(p -> {
            BlockState b = this.level().getBlockState(p);
            if ((b.canOcclude() || b.blocksMotion()) && !b.is(BlockTags.WITHER_IMMUNE)) {
                this.level().destroyBlock(p, true);
            }
        });
    }

    @Override
    public void setCustomCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    @Override
    public int getCustomCooldown() {
        return this.attackCooldown;
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.setFlags(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean canUse() {
            return Geryon.this.isSpawning();
        }

        public void tick() {
            Geryon.this.getNavigation().stop();
        }
    }

    class SummonCowGoal
    extends SummonMobGoal<MadCow> {
        public SummonCowGoal(int summonProgressIn, int summonCooldownIn) {
            super((PathfinderMob)Geryon.this, summonProgressIn, summonCooldownIn, (EntityType)GFRegistry.EntityReg.MAD_COW.get());
        }

        @Override
        public boolean canUse() {
            return super.canUse() && Geryon.this.isNoneState();
        }

        @Override
        public boolean canContinueToUse() {
            return Geryon.this.isSummoning() && this.progressTimer > 0;
        }

        @Override
        public void start() {
            super.start();
            Geryon.this.setSummoning(true);
        }

        @Override
        protected void onSummonMob(MadCow mobEntity) {
            Geryon.this.level().broadcastEntityEvent((Entity)Geryon.this, (byte)11);
        }

        @Override
        public void stop() {
            super.stop();
            Geryon.this.setSummoning(false);
        }
    }

    class SmashAttackGoal
    extends Goal {
        private final double range;
        private final int maxCooldown;
        private int cooldown = 90;
        private boolean isBlockSmash;

        public SmashAttackGoal(double rangeIn, int maxCooldownIn) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.range = rangeIn;
            this.maxCooldown = maxCooldownIn;
        }

        public void start() {
            Geryon.this.setSmashAttack(true);
            this.isBlockSmash = false;
            if (Geryon.this.getTarget() != null) {
                Path path = Geryon.this.getNavigation().createPath((Entity)Geryon.this.getTarget(), 0);
                this.isBlockSmash = null == path;
            }
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return Geryon.this.getTarget() != null && Geryon.this.isNoneState() && Geryon.this.distanceToSqr((Entity)Geryon.this.getTarget()) < this.range * this.range;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            Geryon.this.getNavigation().stop();
            if (Geryon.this.getTarget() != null) {
                Geryon.this.getLookControl().setLookAt((Entity)Geryon.this.getTarget(), (float)Geryon.this.getMaxHeadYRot(), (float)Geryon.this.getMaxHeadXRot());
            }
            if (Geryon.this.smashTime >= 42) {
                Geryon.this.level().broadcastEntityEvent((Entity)Geryon.this, (byte)10);
                Geryon.this.level().getEntities((Entity)Geryon.this, Geryon.this.getBoundingBox().inflate(this.range, this.range / 2.0, this.range)).forEach(e -> Geryon.this.useSmashAttack((Entity)e));
                if (this.isBlockSmash) {
                    Geryon.this.destroyIntersectingBlocks(2.5);
                }
                this.stop();
            }
        }

        public boolean canContinueToUse() {
            return Geryon.this.isSmashAttack();
        }

        public void stop() {
            Geryon.this.setSmashAttack(false);
            this.isBlockSmash = false;
            this.cooldown = this.maxCooldown;
        }
    }

    class GeryonAttackGoal
    extends CooldownMeleeAttackGoal<Geryon> {
        public GeryonAttackGoal(Geryon this$0, double speedIn, boolean useLongMemory, int cooldown) {
            super(this$0, speedIn, useLongMemory, cooldown);
        }
    }
}

