/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class GiantBoar
extends Hoglin {
    public static final TagKey<Item> TRIGGER = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"giant_boar_trigger"));
    private static final EntityDataAccessor<Boolean> SPAWNING = SynchedEntityData.defineId(GiantBoar.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final String KEY_SPAWNING = "Spawning";
    private static final String KEY_SPAWN_TIME = "SpawnTime";
    private static final byte SPAWN_CLIENT = 9;
    private static final int MAX_SPAWN_TIME = 90;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private int spawnTime0;
    private int spawnTime;

    public GiantBoar(EntityType<? extends GiantBoar> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 30;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, 0.31).add(Attributes.KNOCKBACK_RESISTANCE, 0.82).add(Attributes.ATTACK_KNOCKBACK, 1.25).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.ARMOR, 6.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    public static GiantBoar spawnGiantBoar(ServerLevel level, Hoglin hoglin) {
        GiantBoar entity = (GiantBoar)((EntityType)GFRegistry.EntityReg.GIANT_BOAR.get()).create((Level)level);
        entity.copyPosition((Entity)hoglin);
        if (hoglin.hasCustomName()) {
            entity.setCustomName(hoglin.getCustomName());
            entity.setCustomNameVisible(hoglin.isCustomNameVisible());
        }
        entity.setPersistenceRequired();
        entity.yBodyRot = hoglin.yBodyRot;
        entity.setPortalCooldown();
        level.addFreshEntityWithPassengers((Entity)entity);
        entity.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(hoglin.blockPosition()), MobSpawnType.CONVERSION, null);
        entity.setSpawning(true);
        hoglin.ejectPassengers();
        hoglin.discard();
        for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(25.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(player, (Entity)entity);
        }
        entity.playSound(SoundEvents.WITHER_SPAWN, 1.2f, 1.0f);
        return entity;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPAWNING, (Object)Boolean.FALSE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new SpawningGoal());
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        this.spawnTime0 = this.spawnTime;
        if (this.spawnTime > 0 || this.isSpawning()) {
            this.setTarget(null);
            double width = this.getBbWidth();
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.01f, (float)0.01f, (float)0.01f), this.getX() + (this.random.nextDouble() - 0.5) * width, this.getY() + this.random.nextDouble(), this.getZ() + (this.random.nextDouble() - 0.5) * width, 0.0, 0.0, 0.0);
            if (this.spawnTime++ >= 90) {
                this.setSpawning(false);
            }
        }
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.MONSTER;
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public boolean canFallInLove() {
        return false;
    }

    public boolean canBeHunted() {
        return false;
    }

    public boolean isConverting() {
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return this.isSpawning() || source == this.damageSources().inWall() || source.is(DamageTypeTags.WITHER_IMMUNE_TO) || super.isInvulnerableTo(source);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficulty, mobSpawnType, spawnDataIn);
        this.setImmuneToZombification(true);
        this.setBaby(false);
        this.setSpawning(true);
        return result;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected void ageBoundaryReached() {
    }

    protected float getSoundVolume() {
        return 1.5f;
    }

    public float getVoicePitch() {
        return 0.62f + this.random.nextFloat() * 0.24f;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean(KEY_SPAWNING, this.isSpawning());
        compound.putInt(KEY_SPAWN_TIME, this.spawnTime);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSpawning(compound.getBoolean(KEY_SPAWNING));
        this.spawnTime0 = this.spawnTime = compound.getInt(KEY_SPAWN_TIME);
    }

    public boolean isPushable() {
        return false;
    }

    protected void pushEntities() {
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public boolean removeWhenFarAway(double disToPlayer) {
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getCustomName());
        }
        this.bossInfo.setVisible(GreekFantasy.CONFIG.showGiantBoarBossBar());
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void handleEntityEvent(byte id) {
        if (id == 9) {
            this.setSpawning(true);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean isSpawning() {
        return (Boolean)this.getEntityData().get(SPAWNING);
    }

    public void setSpawning(boolean spawning) {
        this.getEntityData().set(SPAWNING, (Object)spawning);
        if (spawning) {
            this.spawnTime = 1;
            if (!this.level().isClientSide()) {
                this.level().broadcastEntityEvent((Entity)this, (byte)9);
            }
        } else {
            this.spawnTime = 0;
        }
    }

    public float getSpawnPercent(float partialTick) {
        if (this.spawnTime <= 0) {
            return 1.0f;
        }
        return Mth.lerp((float)partialTick, (float)this.spawnTime0, (float)this.spawnTime) / 90.0f;
    }

    class SpawningGoal
    extends Goal {
        public SpawningGoal() {
            this.setFlags(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean canUse() {
            return GiantBoar.this.isSpawning();
        }

        public void tick() {
            GiantBoar.this.getNavigation().stop();
            GiantBoar.this.setTarget(null);
        }
    }
}

