/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.Cerastes;
import greekfantasy.entity.ai.MoveToStructureGoal;
import greekfantasy.entity.boss.HydraHead;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

public class Hydra
extends Monster {
    private static final EntityDataAccessor<Byte> HEADS = SynchedEntityData.defineId(Hydra.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final String KEY_HEADS = "Heads";
    public static final int MAX_HEADS = 11;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public Hydra(EntityType<? extends Hydra> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.MOVEMENT_SPEED, 0.24).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.66).add(Attributes.ARMOR, 14.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    public static Hydra spawnHydra(ServerLevel level, Cerastes cerastes) {
        Hydra entity = (Hydra)((EntityType)GFRegistry.EntityReg.HYDRA.get()).create((Level)level);
        entity.copyPosition((Entity)cerastes);
        entity.yBodyRot = cerastes.yBodyRot;
        if (cerastes.hasCustomName()) {
            entity.setCustomName(cerastes.getCustomName());
            entity.setCustomNameVisible(cerastes.isCustomNameVisible());
        }
        entity.setPersistenceRequired();
        entity.setPortalCooldown();
        level.addFreshEntity((Entity)entity);
        entity.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(cerastes.blockPosition()), MobSpawnType.CONVERSION, null);
        cerastes.discard();
        entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 60));
        entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 60));
        entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 60));
        entity.playSound(SoundEvents.WITHER_SPAWN, 1.2f, 1.0f);
        return entity;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEADS, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MoveToTargetGoal((PathfinderMob)this, 1.0, false));
        if (((Boolean)GreekFantasy.CONFIG.HYDRA_SEEK_LAIR.get()).booleanValue()) {
            this.goalSelector.addGoal(4, (Goal)new MoveToStructureGoal((PathfinderMob)this, 1.0, 4, 8, 4, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"hydra_lair"), DefaultRandomPos::getPos));
        }
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                return Hydra.this.random.nextInt(40) == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, false, false));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false, false));
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (!this.getPassengers().isEmpty() && !this.level().isClientSide()) {
            int charred = 0;
            for (Entity entity : this.getPassengers()) {
                HydraHead head = (HydraHead)entity;
                if (!head.isCharred()) continue;
                ++charred;
            }
            if (charred == this.getHeads()) {
                DamageSource source = this.getLastDamageSource();
                this.hurt(source != null ? source : this.damageSources().starve(), this.getMaxHealth() * 2.0f);
                this.getPassengers().forEach(e -> e.discard());
            } else if (this.getHealth() < this.getMaxHealth() && this.random.nextFloat() < 0.125f) {
                this.heal(1.25f * (float)(this.getHeads() - charred));
            }
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficulty, spawnType, spawnDataIn);
        this.addHead(0);
        this.addHead(1);
        this.addHead(2);
        this.setBaby(false);
        return result;
    }

    public boolean canBeAffected(MobEffectInstance potioneffectIn) {
        if (potioneffectIn.getEffect().value() == MobEffects.POISON.value()) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, potioneffectIn, null);
            NeoForge.EVENT_BUS.post((Event)event);
            return event.getApplicationResult();
        }
        return super.canBeAffected(potioneffectIn);
    }

    public boolean requiresCustomPersistence() {
        return this.getHeads() != 3 || super.requiresCustomPersistence();
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getCustomName());
        }
        this.bossInfo.setVisible(GreekFantasy.CONFIG.showHydraBossBar());
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public int getHeads() {
        return ((Byte)this.getEntityData().get(HEADS)).intValue();
    }

    public void setHeads(int heads) {
        this.getEntityData().set(HEADS, (Object)((byte)heads));
    }

    public HydraHead addHead(int id) {
        if (!this.level().isClientSide()) {
            HydraHead head = (HydraHead)((EntityType)GFRegistry.EntityReg.HYDRA_HEAD.get()).create(this.level());
            head.moveTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
            head.setPartId(id);
            if (head.startRiding((Entity)this)) {
                this.setHeads(this.getHeads() + 1);
            } else {
                head.discard();
            }
            return head;
        }
        return null;
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        this.setHeads(Math.max(0, this.getHeads() - 1));
    }

    public void ejectPassengers() {
        super.ejectPassengers();
        this.setHeads(0);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        for (Entity e : this.getPassengers()) {
            if (e.getType() != GFRegistry.EntityReg.HYDRA_HEAD.get()) continue;
            e.remove(reason);
        }
    }

    protected boolean canRide(Entity entity) {
        return false;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().size() < 11;
    }

    public void updatePassenger(Entity passenger, int id, Entity.MoveFunction callback) {
        if (this.hasPassenger(passenger)) {
            int totalHeads = Math.max(1, this.getHeads());
            int rowCount = totalHeads > 5 ? 2 : 1;
            int headsPerRow = (int)Math.ceil((double)totalHeads / (double)rowCount);
            int row = id / headsPerRow;
            int rowIndex = id % headsPerRow;
            int rowHeads = row == rowCount - 1 ? totalHeads - headsPerRow * (rowCount - 1) : headsPerRow;
            rowHeads = Math.max(rowHeads, 1);
            double baseRadius = 0.15 + 0.2 * (double)this.getBbWidth();
            double radius = baseRadius + 0.35 * (double)row;
            double centeredIndex = rowHeads > 1 ? (double)rowIndex - (double)(rowHeads - 1) / 2.0 : 0.0;
            double spread = rowHeads > 1 ? 0.35 : 0.0;
            double angle = Math.toRadians(this.getYRot()) + 1.5707963267948966 + centeredIndex * spread;
            double dx = this.getX() + radius * Math.cos(angle);
            double dy = this.getY() + (double)this.getBbHeight() * (0.4 + 0.08 * (double)row);
            double dz = this.getZ() + radius * Math.sin(angle);
            callback.accept(passenger, dx, dy, dz);
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.BLAZE_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.GENERIC_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GENERIC_DEATH;
    }

    protected float getSoundVolume() {
        return 1.2f;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_HEADS, (byte)this.getHeads());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHeads(compound.getByte(KEY_HEADS));
    }

    class MoveToTargetGoal
    extends MeleeAttackGoal {
        public MoveToTargetGoal(PathfinderMob creature, double speedIn, boolean useLongMemoryIn) {
            super(creature, speedIn, useLongMemoryIn);
        }

        public void tick() {
            super.tick();
            LivingEntity target = Hydra.this.getTarget();
            if (target != null && Hydra.this.distanceToSqr((Entity)target) <= 4.0) {
                Hydra.this.setLastHurtMob((Entity)target);
            }
        }
    }
}

