/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.entity.boss.Hydra;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HydraHead
extends Monster {
    private static final EntityDataAccessor<Byte> PART_ID = SynchedEntityData.defineId(HydraHead.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(HydraHead.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final String KEY_ID = "HydraHeadId";
    private static final String KEY_STATE = "HydraHeadState";
    private static final byte NORMAL = 0;
    private static final byte SEVERED = 1;
    private static final byte GROWING = 2;
    private static final byte CHARRED = 3;
    private static final byte GROWING_EVENT = 8;
    private static final byte CHANGE_SIZE_EVENT = 9;
    private static final byte ATTACK_EVENT = 10;
    private final int maxSeveredTime = 100;
    private int severedTime;
    private final int MAX_GROW_TIME = 60;
    private int growTime;
    private final EntityDimensions severedSize;
    private boolean markForSizeChange;

    public HydraHead(EntityType<? extends HydraHead> type, Level level) {
        super(type, level);
        this.severedSize = EntityDimensions.scalable((float)(type.getWidth() * 0.75f), (float)(type.getHeight() * 0.25f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 22.0).add(Attributes.MOVEMENT_SPEED, 0.24).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PART_ID, (Object)0);
        builder.define(STATE, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new BiteAttackGoal());
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, false, false));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false, false));
    }

    public void aiStep() {
        super.aiStep();
        if (!this.hasHydra() && !this.level().isClientSide()) {
            this.discard();
            return;
        }
        if (!this.level().isClientSide() && this.getTarget() != null && null == this.getHydra().getTarget()) {
            this.getHydra().setTarget(this.getTarget());
        }
        if (!this.isCharred() && this.isSevered() && this.severedTime > 0 && ++this.severedTime > 100) {
            this.severedTime = 0;
            this.setGrowing();
        }
        if (!this.isCharred() && this.isGrowing() && this.growTime > 0 && ++this.growTime > 60) {
            this.growTime = 0;
            this.setHealth(this.getMaxHealth());
            this.setNormal();
        }
    }

    public void tick() {
        super.tick();
        if (this.markForSizeChange || this.level().isClientSide() && !this.isNormal()) {
            this.refreshDimensions();
            this.markForSizeChange = false;
        }
        if (this.level().isClientSide() && this.isCharred() && this.random.nextInt(5) == 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return (this.isSevered() || this.isGrowing()) && !source.is(DamageTypeTags.IS_FIRE) || this.isCharred() || source == this.damageSources().inWall() || source.is(DamageTypeTags.WITHER_IMMUNE_TO) || super.isInvulnerableTo(source);
    }

    public void die(DamageSource cause) {
        if (this.getRemainingFireTicks() > 0) {
            this.setNoAi(true);
            this.setCharred();
        } else {
            this.setSevered();
            HydraHead head = this.getHydra().addHead(this.getHydra().getHeads());
            if (!head.isRemoved()) {
                head.setSevered();
                this.level().addFreshEntity((Entity)head);
            }
        }
        this.setHealth(1.0f);
        this.markForSizeChange = true;
        this.refreshDimensions();
        this.level().broadcastEntityEvent((Entity)this, (byte)9);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!itemstack.isEmpty() && itemstack.is(Items.FLINT_AND_STEEL)) {
            Vec3 pos = this.position();
            this.level().playSound(player, pos.x, pos.y, pos.z, SoundEvents.FLINTANDSTEEL_USE, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            player.swing(hand);
            if (!this.level().isClientSide()) {
                this.igniteForSeconds(4 + this.random.nextInt(3));
                itemstack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isPickable() {
        return this.isNormal();
    }

    protected boolean canRide(Entity entityIn) {
        return entityIn instanceof Hydra;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (super.hurt(source, amount) && this.hasHydra()) {
            this.getHydra().hurt(source, amount * 0.1f);
        }
        return false;
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 0));
            }
            return true;
        }
        return false;
    }

    public void setPartId(int id) {
        this.getEntityData().set(PART_ID, (Object)((byte)id));
    }

    public int getPartId() {
        return ((Byte)this.getEntityData().get(PART_ID)).intValue();
    }

    public boolean hasHydra() {
        return this.getVehicle() instanceof Hydra;
    }

    @Nullable
    public Hydra getHydra() {
        if (this.getVehicle() instanceof Hydra) {
            return (Hydra)this.getVehicle();
        }
        return null;
    }

    public void rideTick() {
        this.setDeltaMovement(Vec3.ZERO);
        if (this.isAlive()) {
            this.tick();
        }
        if (this.isPassenger() && this.hasHydra()) {
            Hydra hydra = this.getHydra();
            hydra.updatePassenger((Entity)this, this.getPartId(), Entity::setPos);
            if (this.yHeadRot > hydra.getYRot() + 80.0f) {
                this.yHeadRot = hydra.getYRot() + 80.0f;
            } else if (this.yHeadRot < hydra.getYRot() - 80.0f) {
                this.yHeadRot = hydra.getYRot() - 80.0f;
            }
        }
    }

    public byte getHeadState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public void setHeadState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
        this.markForSizeChange = true;
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)9);
        }
    }

    public boolean isNormal() {
        return this.getHeadState() == 0;
    }

    public boolean isSevered() {
        return this.severedTime > 0 || this.getHeadState() == 1;
    }

    public boolean isGrowing() {
        return this.growTime > 0 || this.getHeadState() == 2;
    }

    public boolean isCharred() {
        return this.getHeadState() == 3;
    }

    public void setNormal() {
        this.setHeadState((byte)0);
    }

    public void setCharred() {
        this.setHeadState((byte)3);
    }

    public void setSevered() {
        this.setHeadState((byte)1);
        this.severedTime = 1;
    }

    public void setGrowing() {
        this.setHeadState((byte)2);
        this.growTime = 1;
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 8: {
                this.setGrowing();
                this.markForSizeChange = true;
                break;
            }
            case 9: {
                this.markForSizeChange = true;
                break;
            }
            case 10: {
                this.swing(InteractionHand.MAIN_HAND);
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_ID, (byte)this.getPartId());
        compound.putByte(KEY_STATE, this.getHeadState());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setPartId(compound.getByte(KEY_ID));
        this.setHeadState(compound.getByte(KEY_STATE));
    }

    public float getSpawnPercent(float partialTick) {
        if (this.growTime <= 0) {
            return 1.0f;
        }
        return Mth.lerp((float)partialTick, (float)Math.max(0, this.growTime - 1), (float)this.growTime) / 60.0f;
    }

    class BiteAttackGoal
    extends Goal {
        private final int attackInterval = 20;
        private final TargetingConditions targetingConditions;
        private int swingCooldown;
        private long lastCheckTime;

        public BiteAttackGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
            this.targetingConditions = TargetingConditions.forCombat().ignoreLineOfSight();
        }

        public boolean canUse() {
            long i = HydraHead.this.level().getGameTime();
            if (i - this.lastCheckTime < 20L || !HydraHead.this.isNormal()) {
                return false;
            }
            this.lastCheckTime = i;
            LivingEntity livingentity = HydraHead.this.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            return this.getAttackReachSqr(livingentity) >= HydraHead.this.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = HydraHead.this.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            return this.targetingConditions.test((LivingEntity)HydraHead.this, livingentity);
        }

        public void start() {
            HydraHead.this.setAggressive(true);
            this.swingCooldown = 0;
        }

        public void tick() {
            LivingEntity livingentity = HydraHead.this.getTarget();
            HydraHead.this.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            double d0 = HydraHead.this.distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
            this.swingCooldown = Math.max(this.swingCooldown - 1, 0);
            this.checkAndPerformAttack(livingentity, d0);
        }

        public void stop() {
            LivingEntity livingentity = HydraHead.this.getTarget();
            if (null == livingentity || !livingentity.isAlive() || !this.targetingConditions.test((LivingEntity)HydraHead.this, livingentity)) {
                HydraHead.this.setTarget(null);
            }
            HydraHead.this.setAggressive(false);
        }

        protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= d0 && this.swingCooldown <= 0) {
                this.swingCooldown = 20;
                HydraHead.this.swing(InteractionHand.MAIN_HAND);
                HydraHead.this.level().broadcastEntityEvent((Entity)HydraHead.this, (byte)10);
                HydraHead.this.doHurtTarget((Entity)enemy);
            }
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return HydraHead.this.getBbWidth() * 4.5f * HydraHead.this.getBbWidth() * 4.5f + attackTarget.getBbWidth();
        }
    }
}

