/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.CooldownMeleeAttackGoal;
import greekfantasy.entity.ai.MoveToStructureGoal;
import greekfantasy.entity.util.HasCustomCooldown;
import java.util.EnumSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class NemeanLion
extends Monster
implements HasCustomCooldown {
    private static final TagKey<EntityType<?>> BOSSES = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"bosses"));
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(NemeanLion.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final String KEY_STATE = "NemeanState";
    private static final String KEY_ATTACK_TIME = "AttackTime";
    private static final String KEY_SITTING_TIME = "SittingTime";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte ROARING = 2;
    private static final byte ATTACKING = 3;
    private static final byte SITTING = 4;
    private static final byte SITTING_START_EVENT = 8;
    private static final byte SITTING_END_EVENT = 9;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);
    private static final int ATTACK_COOLDOWN = 45;
    private int attackCooldown;
    private static final int MAX_ATTACK_TIME = 6;
    private int attackTime0;
    private int attackTime;
    private static final int MAX_SITTING_TIME = 10;
    private int sittingTime0;
    private int sittingTime;

    public NemeanLion(EntityType<? extends NemeanLion> type, Level level) {
        super(type, level);
        this.setPersistenceRequired();
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.KNOCKBACK_RESISTANCE, 0.92).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.ATTACK_DAMAGE, 9.0).add(Attributes.ARMOR, 5.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RunAroundLikeCrazyGoal(1.0));
        this.goalSelector.addGoal(2, (Goal)new SitGoal());
        this.goalSelector.addGoal(3, (Goal)new NemeanLionAttackGoal(this, 1.15, true, 45));
        if (((Boolean)GreekFantasy.CONFIG.NEMEAN_LION_SEEK_DEN.get()).booleanValue()) {
            this.goalSelector.addGoal(4, (Goal)new MoveToStructureGoal((PathfinderMob)this, 1.0, 3, 8, 4, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"lion_den"), DefaultRandomPos::getPos));
        }
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.86){

            public boolean canUse() {
                return !NemeanLion.this.isSitting() && NemeanLion.this.random.nextInt(400) == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, e -> !this.isVehicle()));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, false, false, e -> e.canChangeDimensions(e.level(), e.level()) && !e.getType().is(BOSSES) && !e.isInWater() && !this.isVehicle()));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, 10, false, false, e -> !this.isVehicle()));
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        this.attackTime0 = this.attackTime;
        if (this.isAttacking()) {
            if (this.attackTime++ >= 6) {
                this.setAttacking(false);
            }
        } else {
            this.attackTime = Math.max(0, this.attackTime - 1);
        }
        boolean sitting = this.isSitting();
        this.sittingTime0 = this.sittingTime;
        this.sittingTime = sitting ? Math.min(this.sittingTime + 1, 10) : Math.max(this.sittingTime - 1, 0);
        if (!this.level().isClientSide()) {
            if (sitting && (this.isAggressive() || this.getTarget() != null || !this.getPassengers().isEmpty())) {
                this.setSitting(false);
            } else if (this.random.nextFloat() < 9.0E-4f) {
                this.setSitting(!sitting);
            }
        }
        if (this.isVehicle() && this.getPassengers().get(0) instanceof Player) {
            Player player = (Player)this.getPassengers().get(0);
            this.setRot(player.getYRot(), player.getXRot() * 0.5f);
            if (this.hurtTime == 0 && !this.level().isClientSide()) {
                this.hurt(this.damageSources().playerAttack(player), 1.0f + this.random.nextFloat());
                if (this.hasEffect(MobEffects.REGENERATION)) {
                    this.removeEffect(MobEffects.REGENERATION);
                }
            }
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            this.setAttacking(true);
            return true;
        }
        return false;
    }

    protected void actuallyHurt(DamageSource source, float amountIn) {
        float damageAmount = amountIn;
        if (!(source.is(DamageTypeTags.BYPASSES_ENCHANTMENTS) || source.is(DamageTypeTags.WITCH_RESISTANT_TO) || source.is(DamageTypeTags.BYPASSES_ARMOR))) {
            damageAmount = Math.min(2.0f, amountIn);
        }
        if (!this.level().isClientSide() && this.isSitting()) {
            this.setSitting(false);
        }
        super.actuallyHurt(source, damageAmount);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source == this.damageSources().inWall() || source.is(DamageTypeTags.WITHER_IMMUNE_TO) || source == this.damageSources().cactus() || source == this.damageSources().sweetBerryBush() || source.is(DamageTypeTags.IS_PROJECTILE) || super.isInvulnerableTo(source);
    }

    protected void doPush(Entity entityIn) {
        if (entityIn instanceof LivingEntity && !this.level().isClientSide() && this.isSitting()) {
            this.setSitting(false);
        }
        super.doPush(entityIn);
    }

    public boolean onClimbable() {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.isVehicle() && !player.isSecondaryUseActive()) {
            if (!this.level().isClientSide() && this.canAddPassenger((Entity)player)) {
                player.startRiding((Entity)this);
                if (this.isSitting()) {
                    this.setSitting(false);
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.FAIL;
    }

    public void ejectPassengers() {
        super.ejectPassengers();
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getCustomName());
        }
        this.bossInfo.setVisible(GreekFantasy.CONFIG.showNemeanLionBossBar());
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public byte getNemeanState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public void setNemeanState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getNemeanState() == 0;
    }

    public boolean isAttacking() {
        return this.getNemeanState() == 3;
    }

    public void setAttacking(boolean attacking) {
        if (attacking) {
            this.setNemeanState((byte)3);
        } else {
            this.setNemeanState((byte)0);
        }
    }

    public boolean isSitting() {
        return this.getNemeanState() == 4;
    }

    public void setSitting(boolean sitting) {
        if (sitting) {
            this.setNemeanState((byte)4);
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
        } else {
            this.setNemeanState((byte)0);
            this.level().broadcastEntityEvent((Entity)this, (byte)9);
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 8: {
                this.setSitting(true);
                break;
            }
            case 9: {
                this.setSitting(false);
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public float getAttackPercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.attackTime0, (float)this.attackTime) / 6.0f;
    }

    public float getSittingPercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.sittingTime0, (float)this.sittingTime) / 10.0f;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_STATE, this.getNemeanState());
        compound.putInt(KEY_ATTACK_TIME, this.attackTime);
        compound.putInt(KEY_SITTING_TIME, this.sittingTime);
        this.saveCustomCooldown(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setNemeanState(compound.getByte(KEY_STATE));
        this.attackTime = compound.getInt(KEY_ATTACK_TIME);
        this.sittingTime = compound.getInt(KEY_SITTING_TIME);
        this.readCustomCooldown(compound);
    }

    @Override
    public void setCustomCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    @Override
    public int getCustomCooldown() {
        return this.attackCooldown;
    }

    class RunAroundLikeCrazyGoal
    extends Goal {
        private final NemeanLion lion;
        private final double speed;
        private double targetX;
        private double targetY;
        private double targetZ;

        public RunAroundLikeCrazyGoal(double speedIn) {
            this.lion = NemeanLion.this;
            this.speed = speedIn;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean canUse() {
            if (this.lion.isVehicle()) {
                Vec3 vector3d = DefaultRandomPos.getPos((PathfinderMob)this.lion, (int)5, (int)4);
                if (vector3d == null) {
                    return false;
                }
                this.targetX = vector3d.x;
                this.targetY = vector3d.y;
                this.targetZ = vector3d.z;
                return true;
            }
            return false;
        }

        public void start() {
            this.lion.getNavigation().moveTo(this.targetX, this.targetY, this.targetZ, this.speed);
        }

        public boolean canContinueToUse() {
            return !this.lion.getNavigation().isDone() && this.lion.isVehicle();
        }

        public void tick() {
            if (this.lion.getRandom().nextInt(42) == 0) {
                Entity e = (Entity)this.lion.getPassengers().get(0);
                this.lion.ejectPassengers();
                if (e instanceof LivingEntity) {
                    LivingEntity passenger = (LivingEntity)e;
                    passenger.knockback(NemeanLion.this.random.nextDouble() * 2.0 - 0.5, NemeanLion.this.random.nextDouble() * 2.0 - 0.75, NemeanLion.this.random.nextDouble() * 2.0 - 0.5);
                    passenger.hurtMarked = true;
                }
            }
        }
    }

    class SitGoal
    extends Goal {
        public SitGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean canUse() {
            return NemeanLion.this.isSitting();
        }

        public void start() {
            super.start();
            NemeanLion.this.setPose(Pose.CROUCHING);
        }

        public void tick() {
            NemeanLion.this.getNavigation().stop();
        }

        public void stop() {
            super.stop();
            if (NemeanLion.this.getPose() == Pose.CROUCHING) {
                NemeanLion.this.setPose(Pose.STANDING);
            }
        }
    }

    class NemeanLionAttackGoal
    extends CooldownMeleeAttackGoal<NemeanLion> {
        public NemeanLionAttackGoal(NemeanLion this$0, double speedIn, boolean useLongMemory, int cooldown) {
            super(this$0, speedIn, useLongMemory, cooldown);
        }
    }
}

