/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.IntervalRangedAttackGoal;
import greekfantasy.entity.misc.PoisonSpit;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Python
extends Monster
implements RangedAttackMob {
    private static final TagKey<EntityType<?>> BOSSES = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"bosses"));
    private static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(Python.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final String KEY_STATE = "PythonState";
    private static final byte NONE = 0;
    private static final byte SPAWNING = 1;
    private static final byte SPIT = 2;
    private static final byte SPIT_EVENT = 9;
    private static final TagKey<EntityType<?>> UNDEAD = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"undead"));
    private static final TagKey<EntityType<?>> ARTHROPOD = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"arthropod"));
    private static final TagKey<EntityType<?>> AQUATIC = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"aquatic"));
    private static final Predicate<LivingEntity> TARGET_SELECTOR = e -> e.isAlive() && !e.getType().is(BOSSES) && e.canChangeDimensions(e.level(), e.level()) && !e.getType().is(UNDEAD) && !e.getType().is(ARTHROPOD) && !e.getType().is(AQUATIC);
    private static final int MAX_SPAWN_TIME = 110;
    private static final int MAX_SPIT_TIME = 66;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);
    private int spawnTime;
    private int spitTime;

    public Python(EntityType<? extends Python> type, Level level) {
        super(type, level);
        this.setPersistenceRequired();
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 70.0).add(Attributes.MOVEMENT_SPEED, 0.31).add(Attributes.ATTACK_DAMAGE, 4.5).add(Attributes.KNOCKBACK_RESISTANCE, 0.8).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ARMOR, 2.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new PoisonSpitAttackGoal(22, 3, 165));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, false, false, TARGET_SELECTOR));
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.isSpawning() && --this.spawnTime <= 0) {
            this.setSpawning(false);
        }
        if (this.isSpitAttack()) {
            ++this.spitTime;
        } else if (this.spitTime > 0) {
            this.spitTime = 0;
        }
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public boolean removeWhenFarAway(double disToPlayer) {
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source == this.damageSources().inWall() || source.is(DamageTypeTags.WITHER_IMMUNE_TO) || super.isInvulnerableTo(source);
    }

    public boolean canBeAffected(MobEffectInstance mobEffect) {
        return mobEffect.getEffect().value() != MobEffects.POISON && super.canBeAffected(mobEffect);
    }

    public boolean onClimbable() {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
        this.bossInfo.setName(this.hasCustomName() ? this.getCustomName() : this.getDisplayName());
        this.bossInfo.setVisible(GreekFantasy.CONFIG.showPythonBossBar());
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SPIDER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.SPIDER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SPIDER_DEATH;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return 0.6f + this.random.nextFloat() * 0.2f;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_STATE, this.getPythonState());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setPythonState(compound.getByte(KEY_STATE));
    }

    public byte getPythonState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public void setPythonState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getPythonState() == 0;
    }

    public boolean isSpitAttack() {
        return this.getPythonState() == 2;
    }

    public void setSpitAttack(boolean smash) {
        this.setPythonState(smash ? (byte)2 : 0);
    }

    public boolean isSpawning() {
        return this.spawnTime > 0 || this.getPythonState() == 1;
    }

    public void setSpawning(boolean spawning) {
        this.spawnTime = spawning ? 110 : 0;
        this.setPythonState(spawning ? (byte)1 : 0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == STATE) {
            this.spawnTime = this.isSpawning() ? 110 : 0;
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 9: {
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (!this.level().isClientSide()) {
            PoisonSpit healingSpell = PoisonSpit.create(this.level(), (LivingEntity)this);
            this.level().addFreshEntity((Entity)healingSpell);
        }
        this.playSound(SoundEvents.LLAMA_SPIT, 1.2f, 1.0f);
    }

    class PoisonSpitAttackGoal
    extends IntervalRangedAttackGoal<Python> {
        protected PoisonSpitAttackGoal(int interval, int count, int maxCooldownIn) {
            super(Python.this, interval, count, maxCooldownIn, 15.0f);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && Python.this.isNoneState();
        }

        @Override
        public void start() {
            super.start();
            Python.this.setSpitAttack(true);
            Python.this.level().broadcastEntityEvent((Entity)Python.this, (byte)9);
            Python.this.playSound(SoundEvents.CREEPER_PRIMED, 1.0f, 1.2f);
        }

        @Override
        public void stop() {
            super.stop();
            Python.this.setSpitAttack(false);
        }
    }
}

