/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.Naiad;
import greekfantasy.entity.Triton;
import greekfantasy.entity.ai.CooldownMeleeAttackGoal;
import greekfantasy.entity.ai.IntervalRangedAttackGoal;
import greekfantasy.entity.boss.Charybdis;
import greekfantasy.entity.misc.WaterSpell;
import greekfantasy.entity.util.HasCustomCooldown;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Scylla
extends WaterAnimal
implements Enemy,
RangedAttackMob,
HasCustomCooldown {
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
    protected static final int MELEE_COOLDOWN = 50;
    protected int meleeCooldown;

    public Scylla(EntityType<? extends Scylla> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 40;
    }

    public static Scylla spawnScylla(ServerLevel world, Naiad naiad) {
        Scylla entity = (Scylla)((EntityType)GFRegistry.EntityReg.SCYLLA.get()).create((Level)world);
        entity.moveTo(naiad.getX(), naiad.getY(), naiad.getZ(), naiad.getYRot(), naiad.getXRot());
        if (naiad.hasCustomName()) {
            entity.setCustomName(naiad.getCustomName());
            entity.setCustomNameVisible(naiad.isCustomNameVisible());
        }
        entity.setPersistenceRequired();
        entity.yBodyRot = naiad.yBodyRot;
        entity.setPortalCooldown();
        world.addFreshEntityWithPassengers((Entity)entity);
        entity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(naiad.blockPosition()), MobSpawnType.CONVERSION, null);
        naiad.discard();
        for (ServerPlayer player : world.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(16.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(player, (Entity)entity);
        }
        entity.playSound(SoundEvents.GHAST_SCREAM, 1.2f, 1.0f);
        return entity;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 140.0).add(Attributes.MOVEMENT_SPEED, 0.08).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ARMOR, 8.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, new IntervalRangedAttackGoal<Scylla>(this, 30, 3, 110, 18.0f));
        this.goalSelector.addGoal(3, new CooldownMeleeAttackGoal<Scylla>(this, 1.0, false, 50));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Naiad.class, true, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Triton.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Dolphin.class, false, false));
    }

    public boolean canAttackType(EntityType<?> type) {
        return type != GFRegistry.EntityReg.CHARYBDIS.get() && super.canAttackType(type);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source == this.damageSources().inWall() || source.is(DamageTypeTags.WITHER_IMMUNE_TO) || source.getEntity() instanceof Charybdis || super.isInvulnerableTo(source);
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        if (this.isInWater()) {
            this.setAirSupply(i);
        }
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.MONSTER;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public boolean removeWhenFarAway(double disToPlayer) {
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    protected void handleAirSupply(int air) {
    }

    public double getFluidJumpThreshold() {
        return 1.0;
    }

    protected float getWaterSlowDown() {
        return 0.95f;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
        this.bossInfo.setName(this.hasCustomName() ? this.getCustomName() : this.getDisplayName());
        this.bossInfo.setVisible(GreekFantasy.CONFIG.showScyllaBossBar());
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.HOSTILE_SPLASH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ELDER_GUARDIAN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ELDER_GUARDIAN_DEATH;
    }

    protected float getSoundVolume() {
        return 1.4f;
    }

    public float getVoicePitch() {
        return 1.2f + this.random.nextFloat() * 0.2f;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (!this.level().isClientSide()) {
            WaterSpell waterSpell = WaterSpell.create(this.level(), (LivingEntity)this);
            double dx = target.getX() - waterSpell.getX();
            double dy = target.getY(0.5) - waterSpell.getY();
            double dz = target.getZ() - waterSpell.getZ();
            double dis = Math.sqrt(dx * dx + dz * dz);
            waterSpell.shoot(dx, dy + dis * waterSpell.getGravity() * 4.0, dz, 1.6f, 1.0f);
            this.level().addFreshEntity((Entity)waterSpell);
        }
        this.playSound(SoundEvents.LLAMA_SPIT, 1.2f, 1.2f + this.random.nextFloat() * 0.2f);
    }

    @Override
    public void setCustomCooldown(int cooldown) {
        this.meleeCooldown = cooldown;
    }

    @Override
    public int getCustomCooldown() {
        return this.meleeCooldown;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.saveCustomCooldown(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readCustomCooldown(compound);
    }
}

