/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.boss;

import greekfantasy.GFRegistry;
import greekfantasy.entity.Automaton;
import greekfantasy.entity.ai.CooldownMeleeAttackGoal;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Talos
extends Automaton
implements Enemy {
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);

    public Talos(EntityType<? extends Talos> type, Level level) {
        super(type, level);
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 260.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.ATTACK_KNOCKBACK, 1.125).add(Attributes.ARMOR, 20.0).add(Attributes.STEP_HEIGHT, (double)0.6f);
    }

    public static Talos spawnTalos(Level level, BlockPos pos, float yaw) {
        Talos entity = (Talos)((EntityType)GFRegistry.EntityReg.TALOS.get()).create(level);
        entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, yaw, 0.0f);
        entity.yBodyRot = yaw;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.addFreshEntityWithPassengers((Entity)entity);
            entity.finalizeSpawn((ServerLevelAccessor)serverLevel, level.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
        }
        entity.setSpawning(true);
        for (ServerPlayer player : level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(25.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(player, (Entity)entity);
        }
        entity.playSound(SoundEvents.WITHER_SPAWN, 1.2f, 1.0f);
        return entity;
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
    }

    @Override
    protected void registerAutomatonGoals() {
        this.goalSelector.addGoal(4, new CooldownMeleeAttackGoal<Talos>(this, 1.0, false, this.getMeleeAttackCooldown()));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    @Override
    protected int getRangedAttackCooldown() {
        return 188;
    }

    @Override
    protected int getMeleeAttackCooldown() {
        return 40;
    }

    @Override
    protected double getBonusAttackKnockback() {
        return 0.92;
    }

    @Override
    protected int getMaxSpawnTime() {
        return 94;
    }

    @Override
    protected int getMaxShootTime() {
        return 80;
    }

    @Override
    public float getMaxShootingAngle() {
        return -0.98f;
    }

    @Override
    protected boolean isHealItem(ItemStack itemStack) {
        return false;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.MONSTER;
    }

    protected float getJumpPower() {
        return 1.2f * super.getJumpPower();
    }

    public boolean isPushable() {
        return false;
    }

    public void pushEntities() {
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    @Override
    public boolean removeWhenFarAway(double disToPlayer) {
        return false;
    }

    @Override
    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypeTags.WITCH_RESISTANT_TO) || source.getDirectEntity() instanceof AbstractArrow || super.isInvulnerableTo(source);
    }

    protected float getSoundVolume() {
        return 1.8f;
    }

    @Override
    public float getVoicePitch() {
        return 0.6f + this.random.nextFloat() * 0.25f;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }
}

