/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import com.google.common.collect.ImmutableList;
import greekfantasy.GFRegistry;
import greekfantasy.entity.misc.MobEffectProjectile;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class Curse
extends MobEffectProjectile {
    private static final Holder<MobEffect>[] CURSES = new Holder[]{MobEffects.BLINDNESS, MobEffects.MOVEMENT_SLOWDOWN, MobEffects.POISON, MobEffects.HARM, MobEffects.WEAKNESS, MobEffects.WITHER, MobEffects.LEVITATION, MobEffects.GLOWING, MobEffects.DIG_SLOWDOWN, MobEffects.HUNGER, MobEffects.CONFUSION, MobEffects.UNLUCK};

    public Curse(EntityType<? extends Curse> entityType, Level world) {
        super(entityType, world);
    }

    protected Curse(Level worldIn, LivingEntity thrower) {
        this((EntityType<? extends Curse>)((EntityType)GFRegistry.EntityReg.CURSE.get()), worldIn);
        this.lifespan = 90;
        this.setOwner((Entity)thrower);
        this.setPos(thrower.getX(), thrower.getEyeY() - 0.1, thrower.getZ());
        this.shootFromRotation((Entity)thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, 0.78f, 0.4f);
        this.markHurt();
    }

    public static Curse create(Level worldIn, LivingEntity thrower) {
        return new Curse(worldIn, thrower);
    }

    @Override
    protected List<MobEffectInstance> getMobEffects(LivingEntity entity) {
        Holder<MobEffect> mobEffect = CURSES[entity.getRandom().nextInt(CURSES.length)];
        return ImmutableList.of((Object)new MobEffectInstance(mobEffect, 200, entity.getRandom().nextInt(2)));
    }

    @Override
    protected ParticleOptions getImpactParticle(LivingEntity entity) {
        return ParticleTypes.DAMAGE_INDICATOR;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SMOKE;
    }

    @Override
    protected float getImpactDamage(LivingEntity entity) {
        return 0.5f;
    }
}

