/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.misc.MobEffectProjectile;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CurseOfCirce
extends MobEffectProjectile {
    public CurseOfCirce(EntityType<? extends CurseOfCirce> entityType, Level world) {
        super(entityType, world);
    }

    protected CurseOfCirce(Level worldIn, LivingEntity thrower) {
        this((EntityType<? extends CurseOfCirce>)((EntityType)GFRegistry.EntityReg.CURSE_OF_CIRCE.get()), worldIn);
        this.lifespan = 90;
        this.setOwner((Entity)thrower);
        this.setPos(thrower.getX(), thrower.getEyeY() - 0.1, thrower.getZ());
        this.shootFromRotation((Entity)thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, 0.78f, 0.4f);
        this.markHurt();
    }

    public static CurseOfCirce create(Level worldIn, LivingEntity thrower) {
        return new CurseOfCirce(worldIn, thrower);
    }

    @Override
    protected List<MobEffectInstance> getMobEffects(LivingEntity entity) {
        DeferredHolder<MobEffect, MobEffect> effect = MobEffects.MOVEMENT_SLOWDOWN;
        int amp = 1;
        if (GreekFantasy.CONFIG.isCurseOfCirceEnabled() && GreekFantasy.CONFIG.isCurseOfCirceApplicable(entity)) {
            effect = GFRegistry.MobEffectReg.CURSE_OF_CIRCE;
            amp = 0;
        }
        int mobEffectDuration = (Integer)GreekFantasy.CONFIG.CURSE_OF_CIRCE_DURATION.get();
        int slownessDuration = entity instanceof Player ? 1 : mobEffectDuration;
        return List.of(new MobEffectInstance(effect, mobEffectDuration, amp, false, true), new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, slownessDuration, amp + 1, false, false, false), new MobEffectInstance(MobEffects.DIG_SLOWDOWN, mobEffectDuration - 1, amp + 1, false, false, false));
    }

    @Override
    protected ParticleOptions getImpactParticle(LivingEntity entity) {
        return ParticleTypes.ENCHANT;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.ENCHANTED_HIT;
    }

    @Override
    protected float getImpactDamage(LivingEntity entity) {
        return 0.0f;
    }
}

