/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Discus
extends ThrowableItemProjectile {
    public Discus(EntityType<? extends Discus> entityType, Level world) {
        super(entityType, world);
    }

    private Discus(Level level, LivingEntity thrower) {
        super((EntityType)GFRegistry.EntityReg.DISCUS.get(), thrower, level);
    }

    private Discus(Level level, double x, double y, double z) {
        super((EntityType)GFRegistry.EntityReg.DISCUS.get(), x, y, z, level);
    }

    public static Discus create(Level level, double x, double y, double z) {
        return new Discus(level, x, y, z);
    }

    public static Discus create(Level level, LivingEntity thrower) {
        return new Discus(level, thrower);
    }

    protected Item getDefaultItem() {
        return (Item)GFRegistry.ItemReg.DISCUS.get();
    }

    protected void onHitEntity(EntityHitResult raytrace) {
        super.onHitEntity(raytrace);
        float damage = (float)(this.getDeltaMovement().horizontalDistanceSqr() * 3.2);
        raytrace.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), damage);
    }

    protected void onHit(HitResult raytrace) {
        Player player;
        Entity entity;
        super.onHit(raytrace);
        if (!(!(this.random.nextFloat() < 0.028f) || (entity = this.getOwner()) instanceof Player && (player = (Player)entity).isCreative())) {
            Vec3 vec = raytrace.getLocation();
            ItemEntity item = new ItemEntity(this.level(), vec.x, vec.y + 0.25, vec.z, new ItemStack((ItemLike)this.getDefaultItem()));
            this.level().addFreshEntity((Entity)item);
        } else {
            this.playSound(SoundEvents.ITEM_BREAK, 1.0f, 1.0f + this.random.nextFloat() * 0.2f);
        }
        this.discard();
    }

    public void tick() {
        Entity entity = this.getOwner();
        if (entity instanceof Player && !entity.isAlive()) {
            this.discard();
        } else {
            super.tick();
        }
    }

    protected double getDefaultGravity() {
        return 0.08;
    }
}

