/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.Sparti;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class DragonTooth
extends ThrowableItemProjectile {
    public DragonTooth(EntityType<? extends DragonTooth> entityType, Level level) {
        super(entityType, level);
    }

    private DragonTooth(Level level, LivingEntity thrower) {
        super((EntityType)GFRegistry.EntityReg.DRAGON_TOOTH.get(), thrower, level);
    }

    private DragonTooth(Level level, double x, double y, double z) {
        super((EntityType)GFRegistry.EntityReg.DRAGON_TOOTH.get(), x, y, z, level);
    }

    public static DragonTooth create(Level level, double x, double y, double z) {
        return new DragonTooth(level, x, y, z);
    }

    public static DragonTooth create(Level level, LivingEntity thrower) {
        return new DragonTooth(level, thrower);
    }

    protected Item getDefaultItem() {
        return (Item)GFRegistry.ItemReg.DRAGON_TOOTH.get();
    }

    protected void onHitEntity(EntityHitResult raytrace) {
        super.onHitEntity(raytrace);
        float damage = (Integer)GreekFantasy.CONFIG.DRAGON_TOOTH_SPARTI_COUNT.get() > 0 ? 0.0f : 1.5f;
        raytrace.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), damage);
    }

    protected void onHit(HitResult raytrace) {
        super.onHit(raytrace);
        if (!this.level().isClientSide() && this.isAlive()) {
            Entity thrower = this.getOwner();
            int n = (Integer)GreekFantasy.CONFIG.DRAGON_TOOTH_SPARTI_COUNT.get();
            int life = 20 * (Integer)GreekFantasy.CONFIG.DRAGON_TOOTH_SPARTI_LIFESPAN.get();
            for (int i = 0; i < n; ++i) {
                Sparti sparti = (Sparti)((EntityType)GFRegistry.EntityReg.SPARTI.get()).create(this.level());
                sparti.moveTo(raytrace.getLocation().x, raytrace.getLocation().y, raytrace.getLocation().z, 0.0f, 0.0f);
                this.level().addFreshEntity((Entity)sparti);
                if (thrower instanceof Player) {
                    Player player = (Player)thrower;
                    sparti.yBodyRot = Mth.wrapDegrees((float)(thrower.getYRot() + 180.0f));
                    sparti.tame(player);
                }
                sparti.setSpawning();
                sparti.setLimitedLife(life);
                sparti.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(new BlockPos((int)raytrace.getLocation().x, (int)raytrace.getLocation().y, (int)raytrace.getLocation().z)), MobSpawnType.MOB_SUMMONED, null);
            }
            this.discard();
        }
    }

    public void tick() {
        Entity entity = this.getOwner();
        if (entity instanceof Player && !entity.isAlive()) {
            this.discard();
        } else {
            super.tick();
        }
    }

    protected double getDefaultGravity() {
        return 0.11;
    }
}

