/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DragonToothHook
extends FishingHook {
    private final int luckBonus;
    private final int speedBonus;

    public DragonToothHook(EntityType<? extends FishingHook> entityType, Level level) {
        super(entityType, level);
        this.luckBonus = 0;
        this.speedBonus = 0;
    }

    public DragonToothHook(Player player, Level level, int luckBonus, int speedBonus) {
        super((EntityType)GFRegistry.EntityReg.DRAGON_TOOTH_HOOK.get(), level);
        this.luckBonus = luckBonus;
        this.speedBonus = speedBonus;
        this.setOwner((Entity)player);
        float f = player.getXRot();
        float f1 = player.getYRot();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.getX() - (double)f3 * 0.3;
        double d1 = player.getEyeY();
        double d2 = player.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.length();
        vec3 = vec3.multiply(0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045);
        this.setDeltaMovement(vec3);
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected void pullEntity(Entity hookedEntity) {
        LivingEntity owner;
        super.pullEntity(hookedEntity);
        Entity entity = this.getOwner();
        LivingEntity livingEntity = owner = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (entity != null && hookedEntity instanceof LivingEntity) {
            Vec3 vec3 = entity.position().subtract(this.position());
            float damageAmount = 1.0f + (float)vec3.scale(0.25).length();
            hookedEntity.hurt(hookedEntity.damageSources().mobProjectile((Entity)this, owner), damageAmount);
        }
    }

    protected double getMaxDistanceSq() {
        return 1024.0;
    }
}

