/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import greekfantasy.block.OliveOilBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GreekFire
extends ThrowableItemProjectile {
    public GreekFire(EntityType<? extends GreekFire> entityType, Level level) {
        super(entityType, level);
    }

    private GreekFire(Level level, LivingEntity thrower) {
        super((EntityType)GFRegistry.EntityReg.GREEK_FIRE.get(), thrower, level);
    }

    private GreekFire(Level level, double x, double y, double z) {
        super((EntityType)GFRegistry.EntityReg.GREEK_FIRE.get(), x, y, z, level);
    }

    public static GreekFire create(Level level, double x, double y, double z) {
        return new GreekFire(level, x, y, z);
    }

    public static GreekFire create(Level level, LivingEntity thrower) {
        return new GreekFire(level, thrower);
    }

    protected Item getDefaultItem() {
        return (Item)GFRegistry.ItemReg.GREEK_FIRE.get();
    }

    protected void onHitEntity(EntityHitResult raytrace) {
        super.onHitEntity(raytrace);
        this.causeExplosion(raytrace.getLocation());
    }

    protected void onHit(HitResult raytrace) {
        super.onHit(raytrace);
        if (!this.level().isClientSide() && this.level() instanceof ServerLevel && this.isAlive()) {
            this.causeExplosion(raytrace.getLocation());
            this.discard();
        }
    }

    protected Explosion causeExplosion(Vec3 vec) {
        float size = 1.25f;
        float size2 = 1.875f;
        Explosion exp = this.level().explode(this.getOwner(), this.damageSources().onFire(), null, vec.x, vec.y, vec.z, 1.25f, false, Level.ExplosionInteraction.NONE);
        BlockState oilBlock = (BlockState)((Block)GFRegistry.BlockReg.OLIVE_OIL.get()).defaultBlockState().setValue((Property)OliveOilBlock.LIT, (Comparable)Boolean.valueOf(true));
        BlockState waterloggedOilBlock = (BlockState)oilBlock.setValue((Property)OliveOilBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        BlockPos origin = new BlockPos((int)vec.x, (int)vec.y, (int)vec.z);
        BlockPos.MutableBlockPos pos = origin.mutable();
        for (float x = -1.875f; x < 1.875f; x += 1.0f) {
            for (float y = -1.875f; y < 1.875f; y += 1.0f) {
                for (float z = -1.875f; z < 1.875f; z += 1.0f) {
                    pos.setWithOffset((Vec3i)origin, Mth.floor((float)x), Mth.floor((float)y), Mth.floor((float)z));
                    if (this.level().random.nextInt(3) <= 0) continue;
                    BlockState state = this.level().getBlockState((BlockPos)pos);
                    if (state.is(BlockTags.REPLACEABLE) && this.level().getBlockState(pos.below()).isSolidRender((BlockGetter)this.level(), pos.below())) {
                        this.level().setBlockAndUpdate((BlockPos)pos, oilBlock);
                        continue;
                    }
                    if (!this.level().getBlockState((BlockPos)pos).getFluidState().is(FluidTags.WATER) || !this.level().isEmptyBlock(pos.above())) continue;
                    this.level().setBlockAndUpdate((BlockPos)pos, waterloggedOilBlock);
                    this.level().setBlock(pos.above(), Blocks.SOUL_FIRE.defaultBlockState(), 2);
                }
            }
        }
        return exp;
    }

    public void tick() {
        BlockHitResult raytraceresult = this.level().clip(new ClipContext(this.position().add(-0.1, -0.1, -0.1), this.position().add(0.1, 0.1, 0.1), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this));
        if (raytraceresult.getType() == HitResult.Type.BLOCK) {
            this.onHit((HitResult)raytraceresult);
        } else {
            super.tick();
        }
    }

    protected double getDefaultGravity() {
        return 0.09;
    }
}

