/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import greekfantasy.entity.misc.MobEffectProjectile;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class HealingSpell
extends MobEffectProjectile {
    private static final TagKey<EntityType<?>> UNDEAD = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"undead"));

    public HealingSpell(EntityType<? extends HealingSpell> entityType, Level world) {
        super(entityType, world);
    }

    protected HealingSpell(Level worldIn, LivingEntity thrower) {
        this((EntityType<? extends HealingSpell>)((EntityType)GFRegistry.EntityReg.HEALING_SPELL.get()), worldIn);
        this.setOwner((Entity)thrower);
        this.setPos(thrower.getX(), thrower.getEyeY() - 0.1, thrower.getZ());
        this.shootFromRotation((Entity)thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, 0.78f, 0.4f);
        this.markHurt();
    }

    public static HealingSpell create(Level worldIn, LivingEntity thrower) {
        return new HealingSpell(worldIn, thrower);
    }

    @Override
    protected List<MobEffectInstance> getMobEffects(LivingEntity entity) {
        return List.of(new MobEffectInstance(MobEffects.HEAL, 1, 1));
    }

    @Override
    protected ParticleOptions getImpactParticle(LivingEntity entity) {
        return entity.getType().is(UNDEAD) ? ParticleTypes.DAMAGE_INDICATOR : ParticleTypes.HEART;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.HAPPY_VILLAGER;
    }

    @Override
    protected float getImpactDamage(LivingEntity entity) {
        return 0.0f;
    }
}

