/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public abstract class MobEffectProjectile
extends Projectile {
    protected int lifespan = 300;

    public MobEffectProjectile(EntityType<? extends MobEffectProjectile> entityType, Level world) {
        super(entityType, world);
    }

    protected void onHitEntity(EntityHitResult raytrace) {
        Object object;
        super.onHitEntity(raytrace);
        Entity thrower = this.getOwner();
        if (raytrace.getEntity() != thrower && (object = raytrace.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)object;
            for (MobEffectInstance effect : this.getMobEffects(livingEntity)) {
                livingEntity.addEffect(effect);
            }
            float damage = this.getImpactDamage(livingEntity);
            if (damage > 0.0f && thrower instanceof LivingEntity) {
                livingEntity.hurt(this.damageSources().mobProjectile((Entity)this, (LivingEntity)thrower), damage);
            }
            this.addParticles(this.getImpactParticle(livingEntity), 6 + this.random.nextInt(6));
        }
    }

    protected void onHit(HitResult raytrace) {
        super.onHit(raytrace);
        if (this.isAlive()) {
            this.discard();
        }
    }

    public void tick() {
        HitResult raytraceresult;
        Entity thrower = this.getOwner();
        if (thrower instanceof Player && !thrower.isAlive()) {
            this.discard();
            return;
        }
        if (this.tickCount > this.lifespan) {
            this.discard();
            return;
        }
        if (!this.level().isClientSide() && (raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
            this.onHit(raytraceresult);
        }
        if (this.tickCount > 2) {
            this.addParticles(this.getTrailParticle(), 2);
        }
        Vec3 motion = this.getDeltaMovement();
        double d0 = this.getX() + motion.x;
        double d1 = this.getY() + motion.y;
        double d2 = this.getZ() + motion.z;
        this.updateRotation();
        this.setPos(d0, d1, d2);
        super.tick();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    abstract List<MobEffectInstance> getMobEffects(LivingEntity var1);

    abstract ParticleOptions getImpactParticle(LivingEntity var1);

    abstract ParticleOptions getTrailParticle();

    abstract float getImpactDamage(LivingEntity var1);

    protected void addParticles(ParticleOptions type, int count) {
        if (this.level().isClientSide()) {
            double x = this.getX();
            double y = this.getY() + 0.1;
            double z = this.getZ();
            double motion = 0.08;
            double width = this.getBbWidth() / 2.0f;
            double height = this.getBbHeight() / 2.0f;
            for (int i = 0; i < count; ++i) {
                this.level().addParticle(type, x + (this.level().random.nextDouble() - 0.5) * width, y + height, z + (this.level().random.nextDouble() - 0.5) * width, (this.level().random.nextDouble() - 0.5) * 0.08, (this.level().random.nextDouble() - 0.5) * 0.08, (this.level().random.nextDouble() - 0.5) * 0.08);
            }
        }
    }
}

