/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import greekfantasy.entity.misc.MobEffectProjectile;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class PoisonSpit
extends MobEffectProjectile {
    public PoisonSpit(EntityType<? extends PoisonSpit> entityType, Level world) {
        super(entityType, world);
    }

    protected PoisonSpit(Level worldIn, LivingEntity thrower) {
        this((EntityType<? extends PoisonSpit>)((EntityType)GFRegistry.EntityReg.POISON_SPIT.get()), worldIn);
        this.lifespan = 80;
        this.setOwner((Entity)thrower);
        this.setPos(thrower.getX(), thrower.getEyeY() - 0.1, thrower.getZ());
        this.shootFromRotation((Entity)thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, 0.78f, 0.4f);
        this.markHurt();
    }

    public static PoisonSpit create(Level worldIn, LivingEntity thrower) {
        return new PoisonSpit(worldIn, thrower);
    }

    @Override
    protected List<MobEffectInstance> getMobEffects(LivingEntity entity) {
        return List.of(new MobEffectInstance(MobEffects.POISON, 90, 1));
    }

    @Override
    protected ParticleOptions getImpactParticle(LivingEntity entity) {
        return ParticleTypes.DAMAGE_INDICATOR;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SNEEZE;
    }

    @Override
    protected float getImpactDamage(LivingEntity entity) {
        return 0.5f;
    }
}

