/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class Spear
extends AbstractArrow {
    protected static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(Spear.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    protected static final String KEY_ITEM = "Item";
    protected static final String KEY_DAMAGE = "DealtDamage";
    protected static final String KEY_SET_FIRE = "SetFire";
    protected boolean dealtDamage;
    protected boolean enchanted;
    protected int loyaltyLevel;
    protected int setFire;
    protected int returningTicks;
    protected ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"textures/entity/spear/wooden_spear.png");

    public Spear(EntityType<? extends Spear> type, Level world) {
        super(type, world);
    }

    public Spear(Level world, LivingEntity thrower, ItemStack item, int setFire) {
        super((EntityType)GFRegistry.EntityReg.SPEAR.get(), thrower, world, item, null);
        this.setArrowStack(item);
        this.setFire = setFire;
    }

    protected ItemStack getDefaultPickupItem() {
        ItemStack item = this.getPickupItem();
        return item.isEmpty() ? new ItemStack((ItemLike)GFRegistry.ItemReg.WOODEN_SPEAR.get()) : item;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ITEM, (Object)ItemStack.EMPTY);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        if ((this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (this.loyaltyLevel > 0 && !this.shouldReturnToThrower()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else if (this.loyaltyLevel > 0) {
                this.setNoPhysics(true);
                Vec3 vector3d = new Vec3(entity.getX() - this.getX(), entity.getEyeY() - this.getY(), entity.getZ() - this.getZ());
                this.setPosRaw(this.getX(), this.getY() + vector3d.y * 0.015 * (double)this.loyaltyLevel, this.getZ());
                if (this.level().isClientSide()) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)this.loyaltyLevel;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vector3d.normalize().scale(d0)));
                if (this.returningTicks == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.tick();
    }

    protected boolean shouldReturnToThrower() {
        Entity entity = this.getOwner();
        return entity != null && entity.isAlive() && (!(entity instanceof ServerPlayer) || !entity.isSpectator());
    }

    protected ItemStack getPickupItem() {
        return ((ItemStack)this.getEntityData().get(ITEM)).copy();
    }

    protected void setArrowStack(ItemStack stack) {
        this.getEntityData().set(ITEM, (Object)stack.copy());
        ResourceLocation name = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        this.texture = ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("textures/entity/spear/" + name.getPath() + ".png"));
        this.loyaltyLevel = stack.getEnchantmentLevel((Holder)this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOYALTY));
        this.enchanted = stack.hasFoil();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(ITEM)) {
            ItemStack stack = this.getPickupItem();
            ResourceLocation name = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            this.texture = ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("textures/entity/spear/" + name.getPath() + ".png"));
            this.loyaltyLevel = stack.getEnchantmentLevel((Holder)this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOYALTY));
            this.enchanted = stack.hasFoil();
        }
    }

    protected void onHitEntity(EntityHitResult raytrace) {
        Entity entity = raytrace.getEntity();
        this.dealtDamage = true;
        Entity thrower = this.getOwner();
        DamageSource source = this.damageSources().thrown((Entity)this, (Entity)(thrower == null ? this : thrower));
        SoundEvent sound = SoundEvents.TRIDENT_HIT;
        if (this.setFire > 0) {
            entity.igniteForSeconds((float)this.setFire);
        }
        if (entity.hurt(source, (float)this.getBaseDamage())) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                this.doPostHurtEffects(living);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(sound, 1.0f, 1.0f);
    }

    protected void doPostHurtEffects(LivingEntity living) {
        super.doPostHurtEffects(living);
        ItemStack stack = this.getPickupItem();
        CustomData customData = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (!customData.isEmpty() && customData.copyTag().contains("Potion")) {
            MobEffectInstance effectInstance;
            CompoundTag nbt = customData.copyTag().getCompound("Potion").copy();
            MobEffect effect = BuiltInRegistries.MOB_EFFECT.getOptional(ResourceLocation.parse((String)nbt.getString("Potion"))).orElse(null);
            if (effect != null) {
                nbt.putByte("Id", (byte)BuiltInRegistries.MOB_EFFECT.getId((Object)effect));
            }
            if ((effectInstance = MobEffectInstance.load((CompoundTag)nbt)) != null) {
                living.addEffect(effectInstance);
            }
        }
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.findHitEntity(startVec, endVec);
    }

    public void playerTouch(Player player) {
        Entity thrower = this.getOwner();
        if (thrower != null && thrower.getUUID() != player.getUUID()) {
            return;
        }
        super.playerTouch(player);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains(KEY_ITEM, 10)) {
            this.setArrowStack(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)tag.getCompound(KEY_ITEM)));
        }
        this.dealtDamage = tag.getBoolean(KEY_DAMAGE);
        this.setFire = tag.getInt(KEY_SET_FIRE);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        CompoundTag itemTag = new CompoundTag();
        this.getPickupItem().save((HolderLookup.Provider)this.registryAccess(), (Tag)itemTag);
        tag.put(KEY_ITEM, (Tag)itemTag);
        tag.putBoolean(KEY_DAMAGE, this.dealtDamage);
        tag.putInt(KEY_SET_FIRE, this.setFire);
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public boolean shouldRender(double dX, double dY, double dZ) {
        return true;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean hasFoil() {
        return this.enchanted;
    }
}

