/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrowingAxe
extends ThrowableItemProjectile {
    protected static final EntityDataAccessor<Boolean> PICKUP = SynchedEntityData.defineId(ThrowingAxe.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final String KEY_DAMAGE = "BaseDamage";
    protected double baseDamage = 2.0;

    public ThrowingAxe(EntityType<? extends ThrowingAxe> type, Level world) {
        super(type, world);
    }

    public ThrowingAxe(Level world, LivingEntity thrower, ItemStack item, boolean pickup) {
        super((EntityType)GFRegistry.EntityReg.THROWING_AXE.get(), thrower, world);
        this.setItem(item);
        this.setPickup(pickup);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PICKUP, (Object)true);
    }

    public void tick() {
        super.tick();
    }

    public void setItem(ItemStack itemStack) {
        super.setItem(itemStack);
        Item item = itemStack.getItem();
        if (item instanceof DiggerItem) {
            DiggerItem diggerItem = (DiggerItem)item;
            this.setBaseDamage(diggerItem.getTier().getAttackDamageBonus());
        }
    }

    protected Item getDefaultItem() {
        return (Item)GFRegistry.ItemReg.THROWING_AXE.get();
    }

    protected void onHitEntity(EntityHitResult raytrace) {
        Entity entity = raytrace.getEntity();
        Entity thrower = this.getOwner();
        DamageSource source = this.damageSources().thrown((Entity)this, (Entity)(thrower == null ? this : thrower));
        SoundEvent sound = SoundEvents.PLAYER_ATTACK_STRONG;
        if (entity.hurt(source, (float)this.getBaseDamage()) && entity.getType() == EntityType.ENDERMAN) {
            return;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(sound, 1.0f, 1.0f);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        ItemStack item = this.getItem();
        if (item.isDamageableItem()) {
            item.setDamageValue(item.getDamageValue() + 1);
        }
        if (this.canPickup()) {
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), item);
            this.level().addFreshEntity((Entity)itemEntity);
        }
        this.discard();
    }

    public void playerTouch(Player player) {
        Entity thrower = this.getOwner();
        if (thrower != null && thrower.getUUID() != player.getUUID()) {
            return;
        }
        super.playerTouch(player);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putDouble(KEY_DAMAGE, this.getBaseDamage());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setBaseDamage(tag.getDouble(KEY_DAMAGE));
    }

    public boolean shouldRender(double dX, double dY, double dZ) {
        return true;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(double baseDamage) {
        this.baseDamage = baseDamage;
    }

    public void setPickup(boolean canPickup) {
        this.getEntityData().set(PICKUP, (Object)canPickup);
    }

    public boolean canPickup() {
        return (Boolean)this.getEntityData().get(PICKUP);
    }

    protected double getDefaultGravity() {
        return 0.08;
    }
}

