/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import greekfantasy.entity.misc.MobEffectProjectile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class WaterSpell
extends MobEffectProjectile {
    public WaterSpell(EntityType<? extends WaterSpell> entityType, Level world) {
        super(entityType, world);
    }

    protected WaterSpell(Level worldIn, LivingEntity thrower) {
        this((EntityType<? extends WaterSpell>)((EntityType)GFRegistry.EntityReg.WATER_SPELL.get()), worldIn);
        this.lifespan = 400;
        this.setOwner((Entity)thrower);
        this.setPos(thrower.getX(), thrower.getEyeY() - 0.1, thrower.getZ());
        this.shootFromRotation((Entity)thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, 0.78f, 0.4f);
        this.markHurt();
    }

    public static WaterSpell create(Level worldIn, LivingEntity thrower) {
        return new WaterSpell(worldIn, thrower);
    }

    @Override
    public void tick() {
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -this.getGravity(), 0.0));
        }
        super.tick();
    }

    @Override
    protected List<MobEffectInstance> getMobEffects(LivingEntity entity) {
        ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
        list.add(new MobEffectInstance(GFRegistry.MobEffectReg.SLOW_SWIM, 180, 2));
        if (this.random.nextInt(15) < 1 + this.level().getDifficulty().getId() * 4) {
            list.add(new MobEffectInstance(MobEffects.POISON, 50, 0));
        }
        return list;
    }

    @Override
    protected ParticleOptions getImpactParticle(LivingEntity entity) {
        return ParticleTypes.DAMAGE_INDICATOR;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SPLASH;
    }

    @Override
    protected float getImpactDamage(LivingEntity entity) {
        return 4.0f;
    }

    protected double getDefaultGravity() {
        return 0.08;
    }
}

