/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.misc;

import greekfantasy.GFRegistry;
import greekfantasy.entity.monster.BabySpider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WebBall
extends ThrowableItemProjectile {
    protected static final EntityDataAccessor<Byte> TYPE = SynchedEntityData.defineId(WebBall.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final String KEY_TYPE = "WebType";
    public static final byte WEB = 1;
    public static final byte SPIDER = 2;
    public static final byte ITEM = 4;

    public WebBall(EntityType<? extends WebBall> entityType, Level level) {
        super(entityType, level);
    }

    private WebBall(Level level, LivingEntity thrower) {
        super((EntityType)GFRegistry.EntityReg.WEB_BALL.get(), thrower, level);
    }

    private WebBall(Level level, double x, double y, double z) {
        super((EntityType)GFRegistry.EntityReg.WEB_BALL.get(), x, y, z, level);
    }

    public static WebBall create(Level level, double x, double y, double z) {
        return new WebBall(level, x, y, z);
    }

    public static WebBall create(Level level, LivingEntity thrower) {
        return new WebBall(level, thrower);
    }

    protected Item getDefaultItem() {
        return (Item)GFRegistry.ItemReg.WEB_BALL.get();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)1);
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        super.onHitEntity(hitResult);
        this.onWebImpact((HitResult)hitResult, hitResult.getLocation());
        this.discard();
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        super.onHitBlock(hitResult);
        this.onWebImpact((HitResult)hitResult, hitResult.getLocation());
        this.discard();
    }

    protected void onHit(HitResult hitResult) {
        if (this.level().isClientSide() || !this.isAlive()) {
            return;
        }
        if (hitResult.getType() == HitResult.Type.BLOCK && this.level().getBlockState(new BlockPos((int)hitResult.getLocation().x, (int)hitResult.getLocation().y, (int)hitResult.getLocation().z)).is(Blocks.COBWEB)) {
            return;
        }
        super.onHit(hitResult);
    }

    public void tick() {
        Entity entity = this.getOwner();
        if (entity instanceof Player && !entity.isAlive()) {
            this.discard();
        } else {
            super.tick();
        }
    }

    protected double getDefaultGravity() {
        return 0.08;
    }

    public void makeStuckInBlock(BlockState blockState, Vec3 stuckSpeedMultiplier) {
        if (!blockState.is(Blocks.COBWEB)) {
            super.makeStuckInBlock(blockState, stuckSpeedMultiplier);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setWebType(tag.getByte(KEY_TYPE));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte(KEY_TYPE, this.getWebType());
    }

    protected void onWebImpact(HitResult raytrace, Vec3 webPos) {
        Level level;
        if (this.level().isClientSide()) {
            return;
        }
        BlockPos hitPos = new BlockPos((int)webPos.x, (int)webPos.y, (int)webPos.z);
        byte type = this.getWebType();
        if (type == 0) {
            this.spawnAtLocation(new ItemStack((ItemLike)Items.STRING));
            return;
        }
        if (this.hasWeb(type) && this.level().isEmptyBlock(hitPos)) {
            this.level().setBlockAndUpdate(hitPos, Blocks.COBWEB.defaultBlockState());
        }
        if (this.hasSpider(type)) {
            BabySpider spider = (BabySpider)((EntityType)GFRegistry.EntityReg.BABY_SPIDER.get()).create(this.level());
            spider.copyPosition((Entity)this);
            spider.restrictTo(hitPos, 12);
            this.level().addFreshEntity((Entity)spider);
        }
        if (this.hasItem(type) && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceKey resourceKey = this.getType().getDefaultLootTable();
            LootTable loottable = serverLevel.getServer().reloadableRegistries().getLootTable(resourceKey);
            LootParams.Builder lootcontext$builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)webPos).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)this.damageSources().fall());
            LootParams ctx = lootcontext$builder.create(LootContextParamSets.ENTITY);
            loottable.getRandomItems(ctx).forEach(arg_0 -> ((WebBall)this).spawnAtLocation(arg_0));
        }
    }

    public void setWebType(byte b) {
        this.getEntityData().set(TYPE, (Object)b);
    }

    public byte getWebType() {
        return (Byte)this.getEntityData().get(TYPE);
    }

    public byte setWebType(boolean web, boolean spider, boolean item) {
        byte type = 0;
        if (web) {
            type = (byte)(type | 1);
        }
        if (spider) {
            type = (byte)(type | 2);
        }
        if (item) {
            type = (byte)(type | 4);
        }
        this.setWebType(type);
        return type;
    }

    public boolean hasWeb(byte webType) {
        return (webType & 1) != 0;
    }

    public boolean hasSpider(byte webType) {
        return (webType & 2) != 0;
    }

    public boolean hasItem(byte webType) {
        return (webType & 4) != 0;
    }
}

