/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BabySpider
extends Spider {
    private boolean isAttacking;

    public BabySpider(EntityType<? extends BabySpider> type, Level level) {
        super(type, level);
        this.xpReward = 1;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, (double)0.36f);
    }

    public float getVoicePitch() {
        return super.getVoicePitch() + 0.5f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.24f));
        this.goalSelector.addGoal(4, (Goal)new AttackGoal((PathfinderMob)this, 1.0, 100));
        this.goalSelector.addGoal(5, (Goal)new RunAroundGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false, false));
    }

    class AttackGoal
    extends MeleeAttackGoal {
        private final int maxCooldown;
        private int cooldown;

        public AttackGoal(PathfinderMob creature, double speedIn, int maxCooldownIn) {
            super(creature, speedIn, false);
            this.maxCooldown = maxCooldownIn;
            this.cooldown = 10;
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                return super.canUse();
            }
            return false;
        }

        public void start() {
            super.start();
            BabySpider.this.isAttacking = true;
        }

        public void stop() {
            super.stop();
            this.cooldown = this.maxCooldown;
            BabySpider.this.isAttacking = false;
        }
    }

    class RunAroundGoal
    extends PanicGoal {
        public RunAroundGoal(PathfinderMob creatureIn, double speedIn) {
            super(creatureIn, speedIn);
        }

        public boolean canUse() {
            if (BabySpider.this.isAttacking) {
                return false;
            }
            return this.findRandomPosition();
        }

        public boolean canContinueToUse() {
            if (BabySpider.this.isAttacking) {
                return false;
            }
            return super.canContinueToUse();
        }
    }
}

