/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.IntervalRangedAttackGoal;
import greekfantasy.entity.misc.CurseOfCirce;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Circe
extends Monster
implements RangedAttackMob {
    protected static final Predicate<LivingEntity> IS_CURSED = e -> e != null && e.getEffect(GFRegistry.MobEffectReg.CURSE_OF_CIRCE) != null;
    protected static final Predicate<LivingEntity> NOT_CURSED = e -> e != null && null == e.getEffect(GFRegistry.MobEffectReg.CURSE_OF_CIRCE);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);

    public Circe(EntityType<? extends Circe> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ARMOR, 1.5);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, new IntervalRangedAttackGoal<Circe>(this, 10, 1, (Integer)GreekFantasy.CONFIG.WAND_OF_CIRCE_COOLDOWN.get() * 4, 10.0f));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 5.0f, 1.4, 1.2, NOT_CURSED.and(e -> e == this.getTarget())));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                return null == Circe.this.getTarget() && Circe.this.random.nextInt(90) == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, NOT_CURSED.and(e -> GreekFantasy.CONFIG.isCurseOfCirceApplicable((LivingEntity)e))));
        this.targetSelector.addGoal(4, (Goal)new ResetTargetGoal());
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.random.nextFloat() < 0.15f && (this.isOnFire() || this.getLastDamageSource() != null && this.getLastDamageSource().is(DamageTypeTags.IS_FIRE)) && !this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 900));
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)GFRegistry.ItemReg.WAND_OF_CIRCE.get()));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnDataIn) {
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficulty, mobSpawnType, spawnDataIn);
        this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
        return result;
    }

    public void performRangedAttack(LivingEntity arg0, float arg1) {
        if (!this.level().isClientSide()) {
            CurseOfCirce spell = CurseOfCirce.create(this.level(), (LivingEntity)this);
            this.level().addFreshEntity((Entity)spell);
        }
        this.playSound(SoundEvents.ILLUSIONER_CAST_SPELL, 1.2f, 1.0f);
        this.swing(InteractionHand.MAIN_HAND);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITCH_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.WITCH_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WITCH_DEATH;
    }

    public float getVoicePitch() {
        return super.getVoicePitch() + 0.2f;
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
        this.bossInfo.setName(this.hasCustomName() ? this.getCustomName() : this.getDisplayName());
        this.bossInfo.setVisible(GreekFantasy.CONFIG.showCirceBossBar());
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    class ResetTargetGoal
    extends Goal {
        protected int interval;

        public ResetTargetGoal() {
            this(10);
        }

        public ResetTargetGoal(int intervalIn) {
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
            this.interval = Math.max(1, intervalIn);
        }

        public boolean canUse() {
            return Circe.this.tickCount % this.interval == 0 && Circe.this.isAlive() && IS_CURSED.test(Circe.this.getTarget());
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            Circe.this.setTarget(null);
        }
    }
}

