/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.enchantment.EnchantmentUtils;
import greekfantasy.entity.ai.MoveToStructureGoal;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;

public class Cyclops
extends Monster {
    public Cyclops(EntityType<? extends Cyclops> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 36.0).add(Attributes.MOVEMENT_SPEED, 0.24).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.8).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.ATTACK_KNOCKBACK, 0.75).add(Attributes.ARMOR, 3.0).add(Attributes.STEP_HEIGHT, (double)0.6f);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Mob.class, 16.0f, 1.2, 1.1, entity -> !entity.isSpectator() && entity.hasCustomName() && "Nobody".equals(entity.getCustomName().getString())));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        if (((Boolean)GreekFantasy.CONFIG.CYCLOPS_SEEK_CAVE.get()).booleanValue()) {
            this.goalSelector.addGoal(4, (Goal)new MoveToStructureGoal((PathfinderMob)this, 1.0, 4, 8, 4, ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"cyclops_cave"), DefaultRandomPos::getPos));
        }
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void dropEquipment() {
        ItemStack mainhand = this.getMainHandItem();
        if (mainhand.isDamageableItem()) {
            int damage = Mth.floor((float)((0.3f + 0.2f * this.random.nextFloat()) * (float)mainhand.getMaxDamage()));
            mainhand.setDamageValue(damage);
        }
        super.dropEquipment();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        if (random.nextBoolean()) {
            Item club = random.nextBoolean() ? (Item)GFRegistry.ItemReg.STONE_CLUB.get() : (Item)GFRegistry.ItemReg.WOODEN_CLUB.get();
            ItemStack itemStack = new ItemStack((ItemLike)club);
            if (random.nextFloat() < 0.1f * difficulty.getSpecialMultiplier()) {
                EnchantmentUtils.enchant(this.level(), itemStack, (ResourceKey<Enchantment>)Enchantments.KNOCKBACK, 1);
            }
            this.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
            this.setDropChance(EquipmentSlot.MAINHAND, 0.1985f);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnDataIn) {
        this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficulty, mobSpawnType, spawnDataIn);
        return result;
    }

    protected float getJumpPower() {
        return 1.1f * super.getJumpPower();
    }
}

