/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import greekfantasy.GFRegistry;
import greekfantasy.entity.Centaur;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class Cyprian
extends Centaur
implements Enemy {
    public Cyprian(EntityType<? extends Cyprian> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 22.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ARMOR, 0.0);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Centaur.class, 10, true, false, e -> e.getType() == GFRegistry.EntityReg.CENTAUR.get()));
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.COW_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.COW_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COW_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 0.8f;
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.MONSTER;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    @Override
    public boolean hasBullHead() {
        return true;
    }

    @Override
    protected void addCentaurGoals() {
    }

    @Override
    public boolean canPlayerTrade(PathfinderMob self, Player player) {
        return false;
    }

    @Override
    public boolean sendAngryParticlesOnFail() {
        return false;
    }
}

