/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootTable;

public class Drakaina
extends Monster {
    private static final EntityDataAccessor<Byte> DATA_VARIANT = SynchedEntityData.defineId(Drakaina.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final String KEY_VARIANT = "Variant";
    private static final String KEY_BVARIANT = "BVariant";

    public Drakaina(EntityType<? extends Drakaina> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 10;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 2.5);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Vex.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)Variant.GREEN.getId());
    }

    public void aiStep() {
        if (this.isAlive()) {
            boolean flag;
            boolean bl = flag = this.shouldBurnInDay() && this.isSunBurnTick() && !this.fireImmune();
            if (flag) {
                ItemStack itemstack = this.getItemBySlot(EquipmentSlot.HEAD);
                if (!itemstack.isEmpty()) {
                    if (itemstack.isDamageableItem()) {
                        itemstack.setDamageValue(itemstack.getDamageValue() + this.random.nextInt(2));
                        if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
                            this.onEquippedItemBroken(itemstack.getItem(), EquipmentSlot.HEAD);
                            this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.igniteForSeconds(8.0f);
                }
            }
        }
        super.aiStep();
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.CAT_HISS;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.SPIDER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SPIDER_DEATH;
    }

    protected float getSoundVolume() {
        return 0.68f;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.getVariant().getLootTable());
    }

    public boolean fireImmune() {
        return this.getVariant() == Variant.RED || super.fireImmune();
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                Variant variant = this.getVariant();
                switch (variant.ordinal()) {
                    case 2: {
                        living.igniteForSeconds((float)(2 + this.random.nextInt(4)));
                        break;
                    }
                    case 1: {
                        living.addEffect(new MobEffectInstance(MobEffects.HUNGER, 20 * (2 + this.random.nextInt(5))));
                        break;
                    }
                    case 0: {
                        living.addEffect(new MobEffectInstance(MobEffects.POISON, 20 * (2 + this.random.nextInt(5))));
                    }
                }
            }
            float f = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            if (this.getMainHandItem().isEmpty() && this.isOnFire() && this.random.nextFloat() < f * 0.3f) {
                entity.igniteForSeconds((float)(2 * (int)f));
            }
            return true;
        }
        return false;
    }

    protected boolean shouldBurnInDay() {
        return this.getVariant() != Variant.RED;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn) {
        Variant variant = spawnType == MobSpawnType.COMMAND || spawnType == MobSpawnType.SPAWN_EGG || spawnType == MobSpawnType.SPAWNER || spawnType == MobSpawnType.DISPENSER ? Variant.getRandom(this.getRandom()) : Variant.getForBiome((Holder<Biome>)worldIn.getBiome(this.blockPosition()));
        this.setVariant(variant);
        SpawnGroupData result = super.finalizeSpawn(worldIn, difficulty, spawnType, spawnDataIn);
        return result;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_BVARIANT, this.getVariant().getId());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains(KEY_VARIANT)) {
            this.setVariant(Variant.getByName(compound.getString(KEY_VARIANT)));
        } else {
            this.setVariant(Variant.getById(compound.getByte(KEY_BVARIANT)));
        }
    }

    public void setVariant(Variant variant) {
        this.getEntityData().set(DATA_VARIANT, (Object)variant.getId());
    }

    public Variant getVariant() {
        return Variant.getById((Byte)this.getEntityData().get(DATA_VARIANT));
    }

    public static enum Variant implements StringRepresentable
    {
        GREEN("green", (TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"has_spawn/green_drakaina"))),
        BROWN("brown", (TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"has_spawn/brown_drakaina"))),
        RED("red", (TagKey<Biome>)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"has_spawn/red_drakaina")));

        private final String name;
        private final ResourceLocation lootTable;
        private final TagKey<Biome> biomeTag;

        private Variant(String name, TagKey<Biome> biomeTag) {
            this.name = name;
            this.lootTable = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)("entities/drakaina/" + this.name));
            this.biomeTag = biomeTag;
        }

        public static Variant getForBiome(Holder<Biome> biome) {
            for (Variant v : Variant.values()) {
                if (!biome.is(v.biomeTag)) continue;
                return v;
            }
            return GREEN;
        }

        public static Variant getRandom(RandomSource rand) {
            int len = Variant.values().length;
            return Variant.values()[rand.nextInt(len)];
        }

        public static Variant getByName(String n) {
            for (Variant t : Variant.values()) {
                if (!t.getSerializedName().equals(n)) continue;
                return t;
            }
            return GREEN;
        }

        public static Variant getById(byte id) {
            return Variant.values()[Mth.clamp((int)id, (int)0, (int)(Variant.values().length - 1))];
        }

        public byte getId() {
            return (byte)this.ordinal();
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

