/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Empusa
extends Monster {
    private static final byte DRAINING_START = 4;
    private static final byte DRAINING_END = 5;
    private boolean isDraining;

    public Empusa(EntityType<? extends Empusa> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.22).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public static boolean checkEmpusaSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource rand) {
        return !level.getLevel().isDay() && Empusa.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)rand);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new DrainAttackGoal(this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() && this.level().isDay() && this.hurtTime == 0 && this.tickCount % 24 == 0) {
            this.hurt(this.damageSources().starve(), 2.0f);
        }
        if (this.level().isClientSide() && this.isDraining()) {
            this.particleRay();
        }
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 4: {
                this.isDraining = true;
                this.playSound(SoundEvents.ENDERMAN_SCREAM, this.getSoundVolume(), this.getVoicePitch());
                break;
            }
            case 5: {
                this.isDraining = false;
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public float getLightLevelDependentMagicValue() {
        return Math.min(1.0f, super.getLightLevelDependentMagicValue() + 0.5f);
    }

    public void setDraining(boolean draining) {
        this.isDraining = draining;
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, draining ? (byte)4 : 5);
        }
    }

    public boolean isDraining() {
        return this.isDraining;
    }

    public void particleRay() {
        Vec3 pos = this.getEyePosition(1.0f).add(0.0, (double)(-this.getBbHeight()) * 0.15, 0.0);
        Vec3 lookVec = this.getLookAngle();
        double l = lookVec.scale(12.0).length();
        double stepSize = 0.25;
        for (double i = 0.0; i < l; i += stepSize) {
            Vec3 scaled = lookVec.scale(i);
            double x = pos.x + scaled.x;
            double y = pos.y + scaled.y;
            double z = pos.z + scaled.z;
            AABB aabb = new AABB(x - 0.1, y - 0.1, z - 0.1, x + 0.1, y + 0.1, z + 0.1);
            if (!this.level().getEntities((Entity)this, aabb).isEmpty()) {
                return;
            }
            this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    static class DrainAttackGoal
    extends Goal {
        private final Empusa entity;
        private final int MAX_DRAIN_TIME = 60;
        private final int HARD_DELTA_DRAIN_TIME = 40;
        private final int MAX_COOLDOWN = 180;
        private final int HARD_DELTA_COOLDOWN = -40;
        private int drainingTime;
        private int cooldown;

        protected DrainAttackGoal(Empusa entityIn) {
            this.setFlags(EnumSet.allOf(Goal.Flag.class));
            this.entity = entityIn;
            this.cooldown = 90;
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                return this.entity.getTarget() != null && this.entity.distanceToSqr((Entity)this.entity.getTarget()) < 36.0 && this.entity.getSensing().hasLineOfSight((Entity)this.entity.getTarget());
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.entity.isDraining() && this.entity.getTarget() != null && this.entity.getSensing().hasLineOfSight((Entity)this.entity.getTarget());
        }

        public void start() {
            this.drainingTime = 60;
            if (this.entity.level().getCurrentDifficultyAt(this.entity.blockPosition()).isHard()) {
                this.drainingTime += 40;
            }
            this.entity.setDraining(true);
        }

        public void tick() {
            if (this.drainingTime > 0 && this.entity.getTarget() != null) {
                --this.drainingTime;
                this.entity.getNavigation().stop();
                this.entity.lookAt((Entity)this.entity.getTarget(), 100.0f, 100.0f);
                if (this.drainingTime > 20 && this.entity.getTarget().hurtTime == 0) {
                    DamageSource src = this.entity.damageSources().indirectMagic((Entity)this.entity, (Entity)this.entity);
                    float amount = (float)this.entity.getAttribute(Attributes.ATTACK_DAMAGE).getValue() * 0.5f;
                    if (this.entity.getTarget().hurt(src, amount)) {
                        this.entity.heal(amount * 1.5f);
                    }
                }
            } else {
                this.stop();
            }
        }

        public void stop() {
            this.entity.setDraining(false);
            this.drainingTime = 0;
            this.cooldown = 180;
            if (this.entity.level().getCurrentDifficultyAt(this.entity.blockPosition()).isHard()) {
                this.cooldown += -40;
            }
        }
    }
}

