/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import greekfantasy.entity.Elpis;
import greekfantasy.entity.ai.IntervalRangedAttackGoal;
import greekfantasy.entity.misc.Curse;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Fury
extends Monster
implements FlyingAnimal,
RangedAttackMob {
    public static final int MAX_AGGRO_TIME = 45;
    private float flyingTime0;
    private float flyingTime;
    private int aggroTime0;
    private int aggroTime;

    public Fury(EntityType<? extends Fury> type, Level level) {
        super(type, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.26).add(Attributes.ATTACK_DAMAGE, 3.5).add(Attributes.FLYING_SPEED, 1.28).add(Attributes.KNOCKBACK_RESISTANCE, 0.4);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, new IntervalRangedAttackGoal<Fury>(this, 90, 2, 200, 14.0f));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 6.0f, 12.0f){

            public boolean canUse() {
                return Fury.this.getRandom().nextInt(110) == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.9){

            public boolean canUse() {
                return Fury.this.getRandom().nextInt(120) == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Elpis.class, true));
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigator.setCanOpenDoors(false);
        flyingpathnavigator.setCanFloat(true);
        flyingpathnavigator.setCanPassDoors(true);
        return flyingpathnavigator;
    }

    public void aiStep() {
        super.aiStep();
        Vec3 m = this.getDeltaMovement();
        if (this.isEffectiveAi() && !this.onGround() && m.y < 0.0) {
            double multY = this.getTarget() != null ? 0.9 : 0.6;
            this.setDeltaMovement(m.multiply(1.0, multY, 1.0));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.flyingTime0 = this.flyingTime;
            this.flyingTime = this.isFlying() ? Math.min(1.0f, this.flyingTime + 0.05f) : Math.max(0.0f, this.flyingTime - 0.05f);
            this.aggroTime0 = this.aggroTime;
            this.aggroTime = this.isAggressive() ? Math.min(this.aggroTime + 1, 45) : Math.max(this.aggroTime - 1, 0);
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.SPIDER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.GHAST_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GHAST_DEATH;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    public float getVoicePitch() {
        return 1.0f + this.random.nextFloat() * 0.2f;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean isFlying() {
        return !this.onGround() || this.getDeltaMovement().lengthSqr() > 0.06;
    }

    public float getFlyingTime(float partialTick) {
        return Mth.clamp((float)Mth.lerp((float)partialTick, (float)this.flyingTime0, (float)this.flyingTime), (float)0.0f, (float)1.0f);
    }

    public float getAggroPercent(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.aggroTime0, (float)this.aggroTime) / 45.0f;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (!this.level().isClientSide()) {
            Curse curse = Curse.create(this.level(), (LivingEntity)this);
            this.level().addFreshEntity((Entity)curse);
        }
        this.playSound(SoundEvents.LLAMA_SPIT, 1.2f, 1.0f);
    }
}

