/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;

public class Gorgon
extends Monster
implements RangedAttackMob {
    private static final TagKey<EntityType<?>> BOSSES = TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"bosses"));
    private static final EntityDataAccessor<Boolean> MEDUSA = SynchedEntityData.defineId(Gorgon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final String KEY_MEDUSA = "Medusa";
    protected static final byte STARE_ATTACK = 9;
    protected static final int PETRIFY_DURATION = 80;
    private static final ResourceKey<LootTable> MEDUSA_LOOT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"entities/medusa"));
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal(this, 1.0, 45, 15.0f);

    public Gorgon(EntityType<? extends Gorgon> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.26).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MEDUSA, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new StareAttackGoal(this, 100));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void aiStep() {
        super.aiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public void thunderHit(ServerLevel world, LightningBolt bolt) {
        if (world.getDifficulty() != Difficulty.PEACEFUL && (double)(this.random.nextFloat() * 100.0f) < (Double)GreekFantasy.CONFIG.MEDUSA_LIGHTNING_CHANCE.get()) {
            this.setMedusa(true);
            this.setHealth(this.getMaxHealth());
            this.setPersistenceRequired();
            this.igniteForSeconds(2.0f);
        } else {
            super.thunderHit(world, bolt);
        }
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.getEntity() != null && source.getEntity().getType() == this.getType()) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (this.getRandom().nextDouble() * 100.0 < (Double)GreekFantasy.CONFIG.MEDUSA_SPAWN_CHANCE.get()) {
            this.setMedusa(true);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 9: {
                this.spawnStareParticles();
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public void spawnStareParticles() {
        if (this.level().isClientSide()) {
            double motion = 0.08;
            double radius = 1.2;
            for (int i = 0; i < 5; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX() + (this.level().random.nextDouble() - 0.5) * 1.2, this.getEyeY() + (this.level().random.nextDouble() - 0.5) * 1.2 * 0.75, this.getZ() + (this.level().random.nextDouble() - 0.5) * 1.2, (this.level().random.nextDouble() - 0.5) * 0.08, (this.level().random.nextDouble() - 0.5) * 0.08 * 0.5, (this.level().random.nextDouble() - 0.5) * 0.08);
            }
            double distance = this.getAttribute(Attributes.FOLLOW_RANGE).getValue();
            List list = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(distance), e -> e.getEffect(GFRegistry.MobEffectReg.PETRIFIED) != null);
            for (Player p : list) {
                this.level().addParticle((ParticleOptions)GFRegistry.ParticleReg.GORGON.get(), true, p.getX(), p.getY(), p.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.CAT_HISS;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.SPIDER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.SPIDER_DEATH;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem item) {
        return item instanceof BowItem;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.getProjectile(this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, i -> i instanceof BowItem)));
        AbstractArrow arrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor, null);
        Item item = this.getMainHandItem().getItem();
        if (item instanceof BowItem) {
            BowItem bow = (BowItem)item;
            arrow = bow.customArrow(arrow, this.getMainHandItem(), itemstack);
        }
        arrow.setPos(this.getX() - (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)Mth.sin((float)(this.yBodyRot * ((float)Math.PI / 180))), this.getEyeY() - 0.1, this.getZ() + (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)Mth.cos((float)(this.yBodyRot * ((float)Math.PI / 180))));
        double dx = target.getX() - arrow.getX();
        double dy = target.getY(0.67) - arrow.getY();
        double dz = target.getZ() - arrow.getZ();
        double dis = Math.sqrt(dx * dx + dz * dz);
        arrow.shoot(dx, dy + dis * (double)0.2f, dz, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    public boolean isPlayerStaring(Player player) {
        Vec3 playerView = player.getViewVector(1.0f).normalize();
        Vec3 distanceVec = new Vec3(this.getX() - player.getX(), this.getEyeY() - player.getEyeY(), this.getZ() - player.getZ());
        double distance = distanceVec.length();
        double dot = playerView.dot(distanceVec = distanceVec.normalize());
        return dot > 1.0 - 0.025 / distance && this.getSensing().hasLineOfSight((Entity)player);
    }

    public boolean isImmuneToStareAttack(LivingEntity target) {
        Player player;
        if (target.isSpectator() || !target.canChangeDimensions(target.level(), target.level()) || target.getType().is(BOSSES) || target instanceof Player && (player = (Player)target).isCreative()) {
            return true;
        }
        if (target.getMainHandItem().is((Item)GFRegistry.ItemReg.MIRROR.get()) || target.getOffhandItem().is((Item)GFRegistry.ItemReg.MIRROR.get())) {
            return true;
        }
        return GreekFantasy.CONFIG.isMirroringEffectEnabled() && target.getEffect(GFRegistry.MobEffectReg.MIRRORING) != null;
    }

    protected void useStareAttack(LivingEntity target) {
        if (((Boolean)GreekFantasy.CONFIG.PETRIFIED_NERF.get()).booleanValue()) {
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, 1));
            target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 80, 1));
        } else {
            target.addEffect(new MobEffectInstance(GFRegistry.MobEffectReg.PETRIFIED, 80, 0, false, false, true));
        }
        if (this.isMedusa()) {
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, 120, 0));
        }
        if (this.isEffectiveAi()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)9);
        }
    }

    public void setMedusa(boolean medusa) {
        this.getEntityData().set(MEDUSA, (Object)medusa);
        this.updateCombatGoal(medusa);
        if (medusa) {
            this.setCustomName((Component)Component.translatable((String)this.getType().getDescriptionId().concat(".medusa")));
        }
    }

    public boolean isMedusa() {
        return (Boolean)this.getEntityData().get(MEDUSA);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key == MEDUSA) {
            if (this.isMedusa()) {
                double medusaHealth = 84.0;
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(84.0);
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(4.0);
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.3);
                this.setHealth(84.0f);
                this.updateCombatGoal(true);
                this.bossInfo.setVisible(GreekFantasy.CONFIG.showMedusaBossBar());
            } else {
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(2.0);
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(24.0);
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.26);
                this.bossInfo.setVisible(false);
                this.updateCombatGoal(false);
            }
        }
    }

    public void updateCombatGoal(boolean medusa) {
        if (this.isEffectiveAi()) {
            if (medusa) {
                this.goalSelector.addGoal(3, (Goal)this.rangedAttackGoal);
                if (!(this.getMainHandItem().getItem() instanceof BowItem)) {
                    this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.BOW));
                }
            } else {
                this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
                if (this.getMainHandItem().getItem() instanceof BowItem) {
                    this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                }
            }
        }
    }

    public boolean canChangeDimensions(Level from, Level to) {
        return !this.isMedusa();
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return this.isMedusa() ? MEDUSA_LOOT : super.getDefaultLootTable();
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
        this.bossInfo.setName(this.hasCustomName() ? this.getCustomName() : this.getDisplayName());
        this.bossInfo.setVisible(this.isMedusa() && GreekFantasy.CONFIG.showMedusaBossBar());
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean(KEY_MEDUSA, this.isMedusa());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setMedusa(compound.getBoolean(KEY_MEDUSA));
        this.updateCombatGoal(this.isMedusa());
    }

    class RangedAttackGoal
    extends net.minecraft.world.entity.ai.goal.RangedAttackGoal {
        public RangedAttackGoal(RangedAttackMob entity, double moveSpeed, int attackInterval, float attackDistance) {
            super(entity, moveSpeed, attackInterval, attackDistance);
        }

        public boolean canUse() {
            return super.canUse() && Gorgon.this.getTarget() != null && Gorgon.this.distanceToSqr((Entity)Gorgon.this.getTarget()) > 16.0 && Gorgon.this.getMainHandItem().getItem() instanceof BowItem;
        }

        public void start() {
            super.start();
            Gorgon.this.setAggressive(true);
        }

        public void stop() {
            super.stop();
            Gorgon.this.setAggressive(false);
        }
    }

    class StareAttackGoal
    extends Goal {
        private final int maxCooldown;
        private int cooldown;
        private List<Player> trackedPlayers = new ArrayList<Player>();

        public StareAttackGoal(Gorgon entityIn, int cooldown) {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
            this.maxCooldown = cooldown;
            this.cooldown = cooldown / 4;
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                double range = Gorgon.this.getAttribute(Attributes.FOLLOW_RANGE).getValue();
                this.trackedPlayers = Gorgon.this.level().getEntitiesOfClass(Player.class, Gorgon.this.getBoundingBox().inflate(range), e -> Gorgon.this.canAttack((LivingEntity)e) && !Gorgon.this.isImmuneToStareAttack((LivingEntity)e) && Gorgon.this.isPlayerStaring((Player)e));
                return !this.trackedPlayers.isEmpty();
            }
            return false;
        }

        public void start() {
            if (!this.trackedPlayers.isEmpty() && this.trackedPlayers.get(0) != null && this.cooldown <= 0) {
                Gorgon.this.getNavigation().stop();
                Gorgon.this.getLookControl().setLookAt((Entity)this.trackedPlayers.get(0), 100.0f, 100.0f);
                this.trackedPlayers.forEach(e -> Gorgon.this.useStareAttack((LivingEntity)e));
                this.trackedPlayers.clear();
                this.cooldown = this.maxCooldown;
            }
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void stop() {
            this.cooldown = this.maxCooldown;
        }
    }
}

