/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import greekfantasy.GFRegistry;
import greekfantasy.entity.Dryad;
import greekfantasy.entity.ai.FindBlockGoal;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class Harpy
extends Monster
implements FlyingAnimal {
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_NEST = SynchedEntityData.defineId(Harpy.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final String KEY_NEST = "Nest";
    private float flyingTime0;
    private float flyingTime;
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;
    private boolean isGoingToNest;

    public Harpy(EntityType<? extends Harpy> type, Level level) {
        super(type, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.22).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FLYING_SPEED, 1.875).add(Attributes.KNOCKBACK_RESISTANCE, 0.32);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_NEST, Optional.empty());
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new FindNestGoal(6, 10, 60));
        this.goalSelector.addGoal(3, (Goal)new GoToNestGoal(0.9, 120));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.9){

            public boolean canUse() {
                return !Harpy.this.isGoingToNest && Harpy.this.getRandom().nextInt(200) == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Dryad.class, 10, true, false, e -> {
            Dryad dryad;
            return e instanceof Dryad && !(dryad = (Dryad)e).isHiding();
        }));
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigator.setCanOpenDoors(false);
        flyingpathnavigator.setCanFloat(true);
        flyingpathnavigator.setCanPassDoors(true);
        return flyingpathnavigator;
    }

    public void aiStep() {
        Optional<BlockPos> nestPos;
        super.aiStep();
        Vec3 m = this.getDeltaMovement();
        if (this.isEffectiveAi() && !this.onGround() && m.y < 0.0) {
            double multY = this.getTarget() != null ? 0.9 : 0.6;
            this.setDeltaMovement(m.multiply(1.0, multY, 1.0));
        }
        this.flyingTime0 = this.flyingTime;
        this.flyingTime = this.isFlying() ? Math.min(1.0f, this.flyingTime + 0.09f) : Math.max(0.0f, this.flyingTime - 0.09f);
        this.calculateFlapping();
        if (this.tickCount % 90 == 0 && (nestPos = this.getNestPos()).isPresent() && !this.level().getBlockState(nestPos.get()).is((Block)GFRegistry.BlockReg.NEST.get())) {
            this.setNestPos(Optional.empty());
        }
    }

    protected SoundEvent getAmbientSound() {
        return this.random.nextFloat() < 0.18f ? SoundEvents.WITCH_AMBIENT : SoundEvents.PARROT_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return this.random.nextFloat() < 0.09f ? SoundEvents.WITCH_HURT : SoundEvents.PARROT_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.GHAST_DEATH;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    public float getVoicePitch() {
        return 0.7f + this.random.nextFloat() * 0.2f;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        Optional<BlockPos> nestPos = this.getNestPos();
        if (nestPos.isPresent()) {
            compound.putInt("Nest.x", nestPos.get().getX());
            compound.putInt("Nest.y", nestPos.get().getY());
            compound.putInt("Nest.z", nestPos.get().getZ());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Nest.x")) {
            int x = compound.getInt("Nest.x");
            int y = compound.getInt("Nest.y");
            int z = compound.getInt("Nest.z");
            this.setNestPos(Optional.of(new BlockPos(x, y, z)));
        }
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    protected void onFlap() {
        this.playSound(SoundEvents.PARROT_FLY, 0.25f, 0.9f);
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    public boolean isFlying() {
        return !this.onGround() || this.getDeltaMovement().lengthSqr() > 0.06;
    }

    public float getFlyingTime(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.flyingTime0, (float)this.flyingTime);
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (float)(!this.onGround() && !this.isPassenger() ? 4 : -1) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public void setNestPos(Optional<BlockPos> pos) {
        this.getEntityData().set(DATA_NEST, pos);
        if (pos.isPresent()) {
            this.restrictTo(pos.get(), (int)Math.ceil(this.getAttribute(Attributes.FOLLOW_RANGE).getBaseValue() * 1.75));
        } else {
            this.clearRestriction();
        }
    }

    public Optional<BlockPos> getNestPos() {
        return (Optional)this.getEntityData().get(DATA_NEST);
    }

    class FindNestGoal
    extends FindBlockGoal {
        public FindNestGoal(int radiusXZ, int radiusY, int cooldown) {
            super((PathfinderMob)Harpy.this, radiusXZ, radiusY, cooldown);
        }

        @Override
        public boolean canUse() {
            return !this.isNearTarget(2.5) && super.canUse();
        }

        @Override
        protected Optional<BlockPos> findNearbyBlock() {
            Optional<BlockPos> nestPos = Harpy.this.getNestPos();
            if (nestPos.isPresent() && this.isTargetBlock((LevelReader)Harpy.this.level(), nestPos.get())) {
                return nestPos;
            }
            return super.findNearbyBlock();
        }

        @Override
        public boolean isTargetBlock(LevelReader level, BlockPos pos) {
            return level.getBlockState(pos).is((Block)GFRegistry.BlockReg.NEST.get());
        }

        @Override
        public void onFoundBlock(LevelReader level, BlockPos pos) {
            Harpy.this.setNestPos(Optional.of(pos));
        }
    }

    class GoToNestGoal
    extends Goal {
        private final double speed;
        private final int chance;

        public GoToNestGoal(double speedIn, int chanceIn) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.speed = speedIn;
            this.chance = chanceIn;
        }

        public boolean canUse() {
            return Harpy.this.getNestPos().isPresent() && !this.isNearNest(4.0) && Harpy.this.getTarget() == null && Harpy.this.getRandom().nextInt(this.chance) == 0;
        }

        public void start() {
            Optional<BlockPos> nestPos = Harpy.this.getNestPos();
            if (nestPos.isPresent()) {
                Vec3 vec = new Vec3((double)nestPos.get().getX() + 0.5, (double)nestPos.get().getY(), (double)nestPos.get().getZ() + 0.5);
                Harpy.this.getNavigation().moveTo(vec.x(), vec.y(), vec.z(), this.speed);
                Harpy.this.isGoingToNest = true;
            }
        }

        public boolean canContinueToUse() {
            return Harpy.this.getNestPos().isPresent() && !Harpy.this.getNavigation().isDone() && Harpy.this.getTarget() == null;
        }

        public void stop() {
            Harpy.this.getNavigation().stop();
            Harpy.this.isGoingToNest = false;
        }

        protected boolean isNearNest(double distance) {
            Optional<BlockPos> nestPos = Harpy.this.getNestPos();
            if (nestPos.isPresent()) {
                Vec3 vec = new Vec3((double)nestPos.get().getX() + 0.5, (double)nestPos.get().getY() + 0.5, (double)nestPos.get().getZ() + 0.5);
                return vec.closerThan((Position)Harpy.this.position(), distance);
            }
            return false;
        }
    }
}

