/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;

public class MadCow
extends Cow
implements Enemy {
    private boolean isAttacking;

    public MadCow(EntityType<? extends MadCow> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Cow.createAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.25);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MadCowAttackGoal((PathfinderMob)this, 1.75, 130));
        this.goalSelector.addGoal(3, (Goal)new MadCowPanicGoal((PathfinderMob)this, 1.75));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void aiStep() {
        super.aiStep();
        if (!this.isPersistenceRequired() && this.random.nextInt(400) == 0) {
            this.hurt(this.damageSources().starve(), 1.0f);
        }
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.MONSTER;
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    class MadCowAttackGoal
    extends MeleeAttackGoal {
        private final int maxCooldown;
        private int cooldown;

        public MadCowAttackGoal(PathfinderMob creature, double speedIn, int maxCooldownIn) {
            super(creature, speedIn, false);
            this.maxCooldown = maxCooldownIn;
            this.cooldown = 10;
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                return super.canUse();
            }
            return false;
        }

        public void start() {
            super.start();
            MadCow.this.isAttacking = true;
        }

        public void stop() {
            super.stop();
            this.cooldown = this.maxCooldown;
            MadCow.this.isAttacking = false;
        }
    }

    class MadCowPanicGoal
    extends PanicGoal {
        public MadCowPanicGoal(PathfinderMob creatureIn, double speedIn) {
            super(creatureIn, speedIn);
        }

        public boolean canUse() {
            if (MadCow.this.isAttacking) {
                return false;
            }
            return this.findRandomPosition();
        }

        public boolean canContinueToUse() {
            if (MadCow.this.isAttacking) {
                return false;
            }
            return super.canContinueToUse();
        }
    }
}

