/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Minotaur
extends Monster {
    protected static final EntityDataAccessor<Byte> STATE = SynchedEntityData.defineId(Minotaur.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final String KEY_STATE = "MinotaurState";
    protected static final byte NONE = 0;
    protected static final byte CHARGING = 1;
    protected static final byte STUNNED = 2;
    protected static final int STUN_DURATION = 80;
    private static final ResourceLocation KNOCKBACK_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"minotaur_charge_knockback");
    private static final ResourceLocation KNOCKBACK_RESISTANCE_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"minotaur_charge_knockback_resistance");
    private static final ResourceLocation ATTACK_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"minotaur_charge_attack");
    protected final AttributeModifier knockbackModifier = new AttributeModifier(KNOCKBACK_MODIFIER_ID, 2.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    protected final AttributeModifier knockbackResistanceModifier = new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_ID, 1.0, AttributeModifier.Operation.ADD_VALUE);
    protected final AttributeModifier attackModifier = new AttributeModifier(ATTACK_MODIFIER_ID, 2.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public Minotaur(EntityType<? extends Minotaur> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.26).add(Attributes.ATTACK_DAMAGE, 3.5).add(Attributes.ATTACK_KNOCKBACK, 1.25).add(Attributes.KNOCKBACK_RESISTANCE, 0.57).add(Attributes.ARMOR, 2.0);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new StunnedGoal());
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.registerChargeGoal();
    }

    protected void registerChargeGoal() {
        this.goalSelector.addGoal(2, (Goal)new ChargeAttackGoal(2.78));
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide() && this.isStunned()) {
            this.spawnStunnedParticles();
        }
    }

    public boolean canAttackType(EntityType<?> entityType) {
        return entityType != GFRegistry.EntityReg.MINOTAUR.get() && entityType != GFRegistry.EntityReg.CRETAN_MINOTAUR.get() && super.canAttackType(entityType);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.COW_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.COW_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COW_DEATH;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.COW_STEP, 0.15f, 1.0f);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isEffectiveAi()) {
            this.setCharging(false);
            this.setStunned(false);
        }
        return super.hurt(source, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte(KEY_STATE, this.getMinotaurState());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setMinotaurState(compound.getByte(KEY_STATE));
    }

    public byte getMinotaurState() {
        return (Byte)this.getEntityData().get(STATE);
    }

    public void setMinotaurState(byte state) {
        this.getEntityData().set(STATE, (Object)state);
    }

    public boolean isNoneState() {
        return this.getMinotaurState() == 0;
    }

    public boolean isCharging() {
        return this.getMinotaurState() == 1;
    }

    public boolean isStunned() {
        return this.getMinotaurState() == 2;
    }

    public void setCharging(boolean charging) {
        this.setMinotaurState(charging ? (byte)1 : 0);
        if (!this.level().isClientSide()) {
            AttributeInstance knockbackResist = this.getAttribute(Attributes.KNOCKBACK_RESISTANCE);
            boolean hasModifier = knockbackResist.hasModifier(KNOCKBACK_RESISTANCE_MODIFIER_ID);
            if (!charging && hasModifier) {
                knockbackResist.removeModifier(KNOCKBACK_RESISTANCE_MODIFIER_ID);
            } else if (charging && !hasModifier) {
                knockbackResist.addTransientModifier(this.knockbackResistanceModifier);
            }
        }
    }

    public void setStunned(boolean stunned) {
        this.setMinotaurState(stunned ? (byte)2 : 0);
    }

    public void spawnStunnedParticles() {
        double motion = 0.09;
        double radius = 0.7;
        for (int i = 0; i < 2; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.INSTANT_EFFECT, this.getX() + (this.level().random.nextDouble() - 0.5) * 0.7, this.getEyeY() + (this.level().random.nextDouble() - 0.5) * 0.7 * 0.75, this.getZ() + (this.level().random.nextDouble() - 0.5) * 0.7, (this.level().random.nextDouble() - 0.5) * 0.09, (this.level().random.nextDouble() - 0.5) * 0.09 * 0.5, (this.level().random.nextDouble() - 0.5) * 0.09);
        }
    }

    public void applyChargeAttack(LivingEntity target) {
        this.getAttribute(Attributes.ATTACK_DAMAGE).addTransientModifier(this.attackModifier);
        this.getAttribute(Attributes.ATTACK_KNOCKBACK).addTransientModifier(this.knockbackModifier);
        this.doHurtTarget((Entity)target);
        this.getAttribute(Attributes.ATTACK_DAMAGE).removeModifier(ATTACK_MODIFIER_ID);
        this.getAttribute(Attributes.ATTACK_KNOCKBACK).removeModifier(KNOCKBACK_MODIFIER_ID);
        if (((Boolean)GreekFantasy.CONFIG.STUNNED_NERF.get()).booleanValue()) {
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, 0));
            target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 80, 0));
        } else {
            target.addEffect(new MobEffectInstance(GFRegistry.MobEffectReg.STUNNED, 80, 0));
        }
    }

    class StunnedGoal
    extends Goal {
        private final int maxStunTime = 50;
        private int stunTime;

        protected StunnedGoal() {
            this.setFlags(EnumSet.allOf(Goal.Flag.class));
        }

        public boolean canUse() {
            return Minotaur.this.isStunned();
        }

        public void start() {
            this.stunTime = 1;
            Minotaur.this.addEffect(new MobEffectInstance(GFRegistry.MobEffectReg.STUNNED, 49));
        }

        public void tick() {
            if (this.stunTime > 0 && this.stunTime < 50) {
                ++this.stunTime;
                Minotaur.this.getNavigation().stop();
                Minotaur.this.getLookControl().setLookAt((Entity)Minotaur.this, 0.0f, 0.0f);
            } else {
                this.stop();
            }
        }

        public void stop() {
            Minotaur.this.setStunned(false);
            this.stunTime = 0;
        }
    }

    public class ChargeAttackGoal
    extends Goal {
        private final int maxCooldown = 200;
        private final int maxCharging = 40;
        private final double minRange = 2.5;
        private final double speed;
        private int chargingTimer;
        private int cooldown = 200;
        private Vec3 targetPos;

        public ChargeAttackGoal(double speedIn) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.speed = speedIn;
            this.targetPos = null;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                return Minotaur.this.isNoneState() && Minotaur.this.getTarget() != null && !Minotaur.this.getMoveControl().hasWanted() && this.hasDirectPath(Minotaur.this.getTarget()) && Minotaur.this.distanceToSqr((Entity)Minotaur.this.getTarget()) > 6.25;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return Minotaur.this.isCharging() && Minotaur.this.getTarget() != null && Minotaur.this.getTarget().isAlive() && this.hasDirectPath(Minotaur.this.getTarget());
        }

        public void start() {
            Minotaur.this.setCharging(true);
            this.chargingTimer = 1;
        }

        public void tick() {
            boolean isCharging;
            LivingEntity target = Minotaur.this.getTarget();
            if (null == target) {
                this.stop();
                return;
            }
            double disSqToTargetEntity = Minotaur.this.distanceToSqr((Entity)target);
            boolean hitTarget = disSqToTargetEntity < 1.1;
            boolean hasTarget = this.targetPos != null;
            boolean finished = hitTarget || hasTarget && Minotaur.this.distanceToSqr(this.targetPos) < 0.9;
            boolean bl = isCharging = this.chargingTimer > 0 && this.chargingTimer++ < 40;
            if (finished) {
                if (hitTarget) {
                    Minotaur.this.applyChargeAttack(target);
                } else {
                    Minotaur.this.setStunned(true);
                }
                this.stop();
            } else if (isCharging) {
                Minotaur.this.getNavigation().stop();
                Minotaur.this.getLookControl().setLookAt(target.getEyePosition(1.0f));
            } else if (hasTarget) {
                Minotaur.this.getMoveControl().setWantedPosition(this.targetPos.x, this.targetPos.y, this.targetPos.z, this.speed);
                Minotaur.this.getLookControl().setLookAt(this.targetPos);
            } else {
                this.targetPos = this.getExtendedTarget(target, disSqToTargetEntity + 16.0);
            }
        }

        public void stop() {
            if (Minotaur.this.isCharging()) {
                Minotaur.this.setCharging(false);
            }
            this.chargingTimer = 0;
            this.cooldown = 200;
            this.targetPos = null;
        }

        private Vec3 getExtendedTarget(LivingEntity targetEntity, double maxDistanceSq) {
            Vec3 target;
            Vec3 start = Minotaur.this.position().add(0.0, 0.1, 0.0);
            Vec3 end = target = targetEntity.position().add(0.0, 0.1, 0.0);
            Vec3 vecDiff = end.subtract(start);
            double length = vecDiff.length();
            vecDiff = vecDiff.normalize();
            do {
                target = end;
                end = start.add(vecDiff.scale(length += 1.0));
            } while (length * length < maxDistanceSq && this.hasDirectPath(end));
            return target;
        }

        private boolean hasDirectPath(LivingEntity target) {
            return this.hasDirectPath(target.position().add(0.0, 0.1, 0.0));
        }

        private boolean hasDirectPath(Vec3 target) {
            Vec3 start = Minotaur.this.position().add(0.0, 0.1, 0.0);
            return Minotaur.this.level().clip(new ClipContext(start, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)Minotaur.this)).getType() == HitResult.Type.MISS;
        }
    }
}

