/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import greekfantasy.GreekFantasy;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class Shade
extends Monster {
    protected static final EntityDataAccessor<Integer> DATA_XP = SynchedEntityData.defineId(Shade.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(Shade.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final String KEY_XP = "StoredXP";
    protected static final String KEY_OWNER = "Owner";

    public Shade(EntityType<? extends Shade> type, Level level) {
        super(type, level);
        this.xpReward = 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.21).add(Attributes.KNOCKBACK_RESISTANCE, 0.86).add(Attributes.ATTACK_DAMAGE, 0.1).add(Attributes.STEP_HEIGHT, 0.5);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, this::canTargetPlayer));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_XP, (Object)0);
        builder.define(OWNER_UNIQUE_ID, Optional.empty());
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            double motion = 0.08;
            double radius = 1.2;
            for (int i = 0; i < 5; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + (this.level().random.nextDouble() - 0.5) * 1.2, this.getY() + 0.75 + (this.level().random.nextDouble() - 0.5) * 1.2 * 0.75, this.getZ() + (this.level().random.nextDouble() - 0.5) * 1.2, (this.level().random.nextDouble() - 0.5) * 0.08, (this.level().random.nextDouble() - 0.5) * 0.08 * 0.5, (this.level().random.nextDouble() - 0.5) * 0.08);
            }
        }
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.totalExperience > 0) {
                    int xpSteal = Math.min(player.totalExperience, 10);
                    player.giveExperiencePoints(-xpSteal);
                    this.setStoredXP(this.getStoredXP() + xpSteal);
                } else {
                    player.addEffect(new MobEffectInstance(MobEffects.WITHER, 60));
                }
            }
            return true;
        }
        return false;
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return effectInstance.getEffect().value() != MobEffects.WITHER && super.canBeAffected(effectInstance);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        Player player;
        if (super.isInvulnerableTo(source)) {
            return true;
        }
        Entity entity = source.getEntity();
        return entity instanceof Player && this.isInvulnerableToPlayer(player = (Player)entity);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundEvents.AMBIENT_CAVE.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENDERMAN_HURT;
    }

    protected float getSoundVolume() {
        return 0.8f;
    }

    public boolean canAttackType(EntityType<?> typeIn) {
        return typeIn == EntityType.PLAYER;
    }

    public boolean isPushable() {
        return false;
    }

    protected void pushEntities() {
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uniqueId) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(uniqueId));
    }

    public int getStoredXP() {
        return (Integer)this.getEntityData().get(DATA_XP);
    }

    public void setStoredXP(int xp) {
        this.getEntityData().set(DATA_XP, (Object)xp);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt(KEY_XP, this.getStoredXP());
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            compound.putUUID(KEY_OWNER, uuid);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setStoredXP(compound.getInt(KEY_XP));
        if (compound.hasUUID(KEY_OWNER)) {
            this.setOwnerUUID(compound.getUUID(KEY_OWNER));
        }
    }

    protected boolean isAlwaysExperienceDropper() {
        return true;
    }

    public int getExperienceReward() {
        return this.getStoredXP();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (this.getStoredXP() == 0) {
            this.setStoredXP(5 + this.getRandom().nextInt(10));
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public boolean canTargetPlayer(LivingEntity entity) {
        Player player;
        return entity instanceof Player && !this.isInvulnerableToPlayer(player = (Player)entity);
    }

    public boolean isInvulnerableToPlayer(Player player) {
        if (((Boolean)GreekFantasy.CONFIG.SHADE_IMMUNE_TO_NONOWNER.get()).booleanValue() && !player.isCreative()) {
            UUID uuidPlayer = player.getUUID();
            return this.getOwnerUUID() != null && !uuidPlayer.equals(this.getOwnerUUID());
        }
        return false;
    }
}

