/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.entity.ai.GoToWaterGoal;
import greekfantasy.entity.ai.WaterAnimalMoveControl;
import greekfantasy.entity.boss.Charybdis;
import greekfantasy.util.SpawnRulesUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class Siren
extends WaterAnimal
implements Enemy {
    private static final EntityDataAccessor<Boolean> CHARMING = SynchedEntityData.defineId(Siren.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final ResourceLocation ATTACK_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"siren_charm_attack");
    private final AttributeModifier attackModifier = new AttributeModifier(ATTACK_MODIFIER_ID, 2.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final int STUN_DURATION = 80;
    protected EntityDimensions swimmingDimensions;

    public Siren(EntityType<? extends Siren> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new WaterAnimalMoveControl((PathfinderMob)this);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
        this.swimmingDimensions = EntityDimensions.scalable((float)0.6f, (float)0.6f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 24.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.STEP_HEIGHT, 0.6);
    }

    public static boolean checkSirenSpawnRules(EntityType<? extends PathfinderMob> entityType, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource rand) {
        return SpawnRulesUtil.checkSurfaceWaterMobSpawnRules(entityType, level, mobSpawnType, pos, rand);
    }

    protected PathNavigation createNavigation(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new GoToWaterGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new CharmAttackGoal(250, 100, 12));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Charybdis.class, 12.0f, 1.0, 1.0));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Pufferfish.class, 10.0f, 1.2, 1.0));
        this.goalSelector.addGoal(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.9, 140));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CHARMING, (Object)Boolean.FALSE);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isCharming() && this.random.nextInt(8) == 0) {
            float color = 0.065f + this.random.nextFloat() * 0.025f;
            this.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), 1.8f, color * 15.0f);
            this.level().addParticle((ParticleOptions)ParticleTypes.NOTE, this.getX(), this.getEyeY() + 0.15, this.getZ(), (double)color, 0.0, 0.0);
        }
    }

    public void baseTick() {
        int i = this.getAirSupply();
        super.baseTick();
        if (this.isInWater()) {
            this.setAirSupply(i);
        }
    }

    public void tick() {
        super.tick();
        boolean inWater = this.isInWaterRainOrBubble();
        if (!inWater && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.2f)));
            this.setYRot(this.random.nextFloat() * 360.0f);
            this.setOnGround(false);
            this.hasImpulse = true;
        }
        if (!inWater || this.getDeltaMovement().horizontalDistanceSqr() > 0.0012) {
            this.setPose(Pose.SWIMMING);
        } else if (this.getPose() == Pose.SWIMMING) {
            this.setPose(Pose.STANDING);
        }
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return MobCategory.MONSTER;
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            this.setSwimming(true);
        }
    }

    protected void handleAirSupply(int air) {
    }

    public boolean isPushedByFluid() {
        return !this.isSwimming();
    }

    public void setCharming(boolean isCharming) {
        this.getEntityData().set(CHARMING, (Object)isCharming);
    }

    public boolean isCharming() {
        return (Boolean)this.getEntityData().get(CHARMING);
    }

    public boolean doHurtTarget(Entity target) {
        boolean charming = this.isCharming();
        if (charming) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).addTransientModifier(this.attackModifier);
        }
        boolean success = super.doHurtTarget(target);
        if (charming) {
            this.getAttribute(Attributes.ATTACK_DAMAGE).removeModifier(ATTACK_MODIFIER_ID);
        }
        if (charming && success && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (((Boolean)GreekFantasy.CONFIG.STUNNED_NERF.get()).booleanValue()) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, 0));
                livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 80, 0));
            } else {
                livingEntity.addEffect(new MobEffectInstance(GFRegistry.MobEffectReg.STUNNED, 80, 0));
            }
        }
        return success;
    }

    class CharmAttackGoal
    extends Goal {
        protected final int maxDuration;
        protected final int maxCooldown;
        protected final float range;
        protected int duration;
        protected int cooldown;

        public CharmAttackGoal(int duration, int cooldown, int range) {
            this.setFlags(EnumSet.noneOf(Goal.Flag.class));
            this.duration = 0;
            this.maxDuration = duration;
            this.maxCooldown = cooldown;
            this.cooldown = 60;
            this.range = range;
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else {
                return Siren.this.getTarget() != null && Siren.this.closerThan((Entity)Siren.this.getTarget(), this.range);
            }
            return false;
        }

        public void start() {
            Siren.this.setCharming(true);
            this.duration = this.maxDuration;
        }

        public boolean canContinueToUse() {
            return this.duration > 0 && Siren.this.getTarget() != null && Siren.this.closerThan((Entity)Siren.this.getTarget(), this.range);
        }

        public void tick() {
            super.tick();
            if (this.duration-- > 0) {
                LivingEntity target = Siren.this.getTarget();
                target.addEffect(new MobEffectInstance(GFRegistry.MobEffectReg.SLOW_SWIM, this.maxDuration, 2));
            } else {
                this.stop();
            }
        }

        public void stop() {
            this.duration = 0;
            this.cooldown = this.maxCooldown;
            Siren.this.setCharming(false);
        }
    }
}

