/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.monster;

import greekfantasy.entity.misc.BronzeFeather;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Stymphalian
extends Monster
implements FlyingAnimal,
RangedAttackMob {
    private float flyingTime0;
    private float flyingTime;
    protected boolean isFlyingUp;

    public Stymphalian(EntityType<? extends Stymphalian> type, Level level) {
        super(type, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.26).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FLYING_SPEED, 1.35).add(Attributes.ARMOR, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.32);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FlyingRangedAttackGoal(this, 1.0, 60, 80, 10.0f));
        this.goalSelector.addGoal(3, (Goal)new FollowMobGoal((Mob)this, 1.0, 6.0f, 12.0f){

            public boolean canUse() {
                return Stymphalian.this.getRandom().nextInt(70) == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.9){

            public boolean canUse() {
                return Stymphalian.this.getRandom().nextInt(20) == 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, true));
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigator.setCanOpenDoors(false);
        flyingpathnavigator.setCanFloat(true);
        flyingpathnavigator.setCanPassDoors(true);
        return flyingpathnavigator;
    }

    public void aiStep() {
        super.aiStep();
        Vec3 m = this.getDeltaMovement();
        if (this.isEffectiveAi() && !this.onGround() && m.y() > 0.0) {
            this.setDeltaMovement(m.add(0.0, -0.01, 0.0));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.flyingTime0 = this.flyingTime;
            this.flyingTime = this.isFlying() ? Math.min(1.0f, this.flyingTime + 0.09f) : Math.max(0.0f, this.flyingTime - 0.09f);
        }
    }

    public void travel(Vec3 vec3) {
        super.travel(vec3);
        if (this.isFlyingUp) {
            this.move(MoverType.SELF, new Vec3(0.0, 0.032, 0.0));
        } else if (this.isFlying()) {
            this.move(MoverType.SELF, new Vec3(0.0, -0.03, 0.0));
        }
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PARROT_IMITATE_PHANTOM;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.PARROT_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PARROT_DEATH;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return 1.0f + this.random.nextFloat() * 0.2f;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean isFlying() {
        return !this.onGround() || this.getDeltaMovement().lengthSqr() > 0.06;
    }

    public float getFlyingTime(float partialTick) {
        return Mth.clamp((float)Mth.lerp((float)partialTick, (float)this.flyingTime0, (float)this.flyingTime), (float)0.0f, (float)1.0f);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (!this.level().isClientSide()) {
            BronzeFeather bronzeFeather = BronzeFeather.create(this.level(), (LivingEntity)this);
            double dx = target.getX() - bronzeFeather.getX();
            double dy = target.getY(0.67) - bronzeFeather.getY();
            double dz = target.getZ() - bronzeFeather.getZ();
            double dis = Math.sqrt(dx * dx + dz * dz);
            bronzeFeather.shoot(dx, dy + dis * (double)0.02f, dz, 1.6f, 14 - this.level().getDifficulty().getId() * 4);
            this.level().addFreshEntity((Entity)bronzeFeather);
        }
        this.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 1.2f, 1.2f + this.random.nextFloat() * 0.2f);
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        if (damageSource.is(DamageTypeTags.IS_PROJECTILE) && damageSource.getDirectEntity() instanceof BronzeFeather) {
            return true;
        }
        return super.isInvulnerableTo(damageSource);
    }

    static class FlyingRangedAttackGoal
    extends RangedAttackGoal {
        protected final Stymphalian entity;

        public FlyingRangedAttackGoal(Stymphalian entity, double speedModifier, int attackIntervalMin, int attackIntervalMax, float maxDistance) {
            super((RangedAttackMob)entity, speedModifier, attackIntervalMin, attackIntervalMax, maxDistance);
            this.entity = entity;
        }

        public void start() {
            super.start();
            this.entity.setAggressive(true);
        }

        public void tick() {
            super.tick();
            if (this.entity.getTarget() != null) {
                double desiredHeight;
                LivingEntity target = this.entity.getTarget();
                Vec3 targetPos = target.position();
                double dy = this.entity.position().y() - (targetPos.y() + (double)target.getDimensions(target.getPose()).height());
                this.entity.isFlyingUp = dy < (desiredHeight = 1.0 + 1.5 * ((double)(this.entity.getId() % 16) / 16.0));
            }
        }

        public void stop() {
            super.stop();
            this.entity.isFlyingUp = false;
            this.entity.setAggressive(false);
        }
    }
}

