/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.entity.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public interface TradingMob {
    @Nullable
    public Player getTradingPlayer();

    public void setTradingPlayer(@Nullable Player var1);

    default public boolean canPlayerTrade(PathfinderMob self, Player player) {
        return player != null && player != self.getTarget();
    }

    default public boolean isTrading() {
        return this.getTradingPlayer() != null;
    }

    public TagKey<Item> getTradeTag();

    public ResourceLocation getTradeLootTable();

    default public boolean sendAngryParticlesOnFail() {
        return true;
    }

    default public List<ItemStack> getTradeResult(PathfinderMob self, @Nullable Player player, ItemStack tradeItem) {
        ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.getTradeLootTable());
        LootTable loottable = self.level().getServer().reloadableRegistries().getLootTable(lootTableKey);
        return loottable.getRandomItems(new LootParams.Builder((ServerLevel)self.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)self).withParameter(LootContextParams.ORIGIN, (Object)self.position()).withParameter(LootContextParams.TOOL, (Object)tradeItem).create(LootContextParamSets.PIGLIN_BARTER));
    }

    default public void trade(PathfinderMob self, @Nullable Player player, ItemStack tradeItem) {
        Vec3 tradeTargetPos = this.getTradeTargetPosition(self, player);
        this.getTradeResult(self, player, tradeItem).forEach(item -> BehaviorUtils.throwItem((LivingEntity)self, (ItemStack)item, (Vec3)tradeTargetPos));
        tradeItem.shrink(1);
        self.setItemInHand(InteractionHand.MAIN_HAND, tradeItem);
        if (tradeItem.getCount() <= 0) {
            this.setTradingPlayer(null);
        }
        if (player != null && self.getRandom().nextInt(3) == 0) {
            self.level().addFreshEntity((Entity)new ExperienceOrb(self.level(), self.getX(), self.getY(), self.getZ(), 1 + self.getRandom().nextInt(2)));
        }
    }

    default public InteractionResult startTrading(PathfinderMob self, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!this.isTrading() && !self.isAggressive() && self.getOffhandItem().isEmpty() && !stack.isEmpty() && stack.is(this.getTradeTag())) {
            Level level;
            if (this.canPlayerTrade(self, player)) {
                this.setTradingPlayer(player);
                self.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)stack.getItem()));
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                player.setItemInHand(hand, stack);
                return InteractionResult.sidedSuccess((boolean)self.level().isClientSide);
            }
            if (this.sendAngryParticlesOnFail() && (level = self.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, self.getX(), self.getEyeY(), self.getZ(), 4, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return InteractionResult.PASS;
    }

    default public Vec3 getTradeTargetPosition(PathfinderMob self, @Nullable Player player) {
        Vec3 tradeTarget;
        if (player != null) {
            tradeTarget = player.getEyePosition();
        } else {
            tradeTarget = LandRandomPos.getPos((PathfinderMob)self, (int)4, (int)2);
            if (null == tradeTarget) {
                tradeTarget = self.getEyePosition();
            }
        }
        return tradeTarget;
    }
}

