/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.integration;

import greekfantasy.GreekFantasy;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public final class RGCompat {
    private static RGCompat instance;
    private static final ResourceLocation APOLLO;
    private static final ResourceLocation HADES;
    private static final ResourceLocation HERMES;
    private static final ResourceLocation POSEIDON;
    private static final ResourceLocation ZEUS;

    public static RGCompat getInstance() {
        if (null == instance) {
            instance = new RGCompat();
        }
        return instance;
    }

    public boolean canUseRaising(Player player) {
        return this.hasFavorRange(player, HADES, 9, 10) || this.hasPatron(player, HADES);
    }

    public boolean canUseLordOfTheSea(Player player) {
        return this.hasFavorRange(player, POSEIDON, 9, 10) || this.hasPatron(player, POSEIDON);
    }

    public boolean canUseFireflash(Player player) {
        return this.hasFavorRange(player, ZEUS, 9, 10) || this.hasPatron(player, ZEUS);
    }

    public boolean canUseFlying(Player player) {
        return this.hasFavorRange(player, HERMES, 9, 10) || this.hasPatron(player, HERMES);
    }

    public boolean canUseDaybreak(Player player) {
        return this.hasFavorRange(player, APOLLO, 9, 10) || this.hasPatron(player, APOLLO);
    }

    public boolean canRemovePrisonerEffect(Player player) {
        return this.hasFavorRange(player, HADES, 4, 10) || this.hasPatron(player, HADES);
    }

    private boolean hasFavorRange(Player player, ResourceLocation deity, int min, int max) {
        if (!GreekFantasy.isRGLoaded()) {
            return false;
        }
        return false;
    }

    private boolean hasPatron(Player player, ResourceLocation deity) {
        if (!GreekFantasy.isRGLoaded()) {
            return false;
        }
        return false;
    }

    static {
        APOLLO = ResourceLocation.fromNamespaceAndPath((String)"greek", (String)"apollo");
        HADES = ResourceLocation.fromNamespaceAndPath((String)"greek", (String)"hades");
        HERMES = ResourceLocation.fromNamespaceAndPath((String)"greek", (String)"hermes");
        POSEIDON = ResourceLocation.fromNamespaceAndPath((String)"greek", (String)"poseidon");
        ZEUS = ResourceLocation.fromNamespaceAndPath((String)"greek", (String)"zeus");
    }
}

