/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GreekFantasy;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class BagOfWindItem
extends Item {
    public BagOfWindItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int duration = (Integer)GreekFantasy.CONFIG.BAG_OF_WIND_DURATION.get();
        player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, duration, 1));
        player.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, duration, 0));
        player.getCooldowns().addCooldown((Item)this, ((Integer)GreekFantasy.CONFIG.BAG_OF_WIND_COOLDOWN.get()).intValue());
        if (!player.isCreative()) {
            stack.hurtAndBreak(((Integer)GreekFantasy.CONFIG.BAG_OF_WIND_DURABILITY_ON_USE.get()).intValue(), (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        }
        player.playSound(SoundEvents.ELYTRA_FLYING, 0.11f, 1.0f);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return toRepair.getItem() == this && toRepair.getDamageValue() < toRepair.getMaxDamage() && repair.is(Items.FEATHER);
    }
}

