/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GFRegistry;
import greekfantasy.GreekFantasy;
import greekfantasy.enchantment.EnchantmentUtils;
import greekfantasy.enchantment.GFEnchantments;
import greekfantasy.entity.Sparti;
import greekfantasy.integration.RGCompat;
import greekfantasy.item.SpearItem;
import greekfantasy.item.ThunderboltItem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BidentItem
extends SpearItem {
    public BidentItem(Tier tier, Item.Properties properties) {
        super(tier, 0.75f, properties, 4);
    }

    @Override
    protected void throwSpear(Level level, Player thrower, ItemStack stack) {
        if (EnchantmentUtils.getEnchantmentLevel(level, GFEnchantments.RAISING, stack) > 0 && level instanceof ServerLevel && (!GreekFantasy.isRGLoaded() || RGCompat.getInstance().canUseRaising(thrower))) {
            BlockHitResult raytrace = ThunderboltItem.raytraceFromEntity((LivingEntity)thrower, 5.0f);
            if (raytrace.getType() != HitResult.Type.MISS) {
                stack.hurtAndBreak(25, (LivingEntity)thrower, thrower.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                Sparti sparti = (Sparti)((EntityType)GFRegistry.EntityReg.SPARTI.get()).create(level);
                sparti.setPos(raytrace.getLocation().x(), raytrace.getLocation().y(), raytrace.getLocation().z());
                sparti.yBodyRot = Mth.wrapDegrees((float)(thrower.getYRot() + 180.0f));
                sparti.setLimitedLife((Integer)GreekFantasy.CONFIG.RAISING_SPARTI_LIFESPAN.get() * 20);
                thrower.playSound(SoundEvents.LAVA_EXTINGUISH, 0.8f, 0.9f + thrower.getRandom().nextFloat() * 0.2f);
                level.addFreshEntity((Entity)sparti);
                sparti.tame(thrower);
                sparti.setSpawning();
                sparti.finalizeSpawn((ServerLevelAccessor)((ServerLevel)level), level.getCurrentDifficultyAt(new BlockPos((int)raytrace.getLocation().x, (int)raytrace.getLocation().y, (int)raytrace.getLocation().z)), MobSpawnType.MOB_SUMMONED, null);
            }
        } else {
            super.throwSpear(level, thrower, stack);
        }
    }
}

