/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ClubItem
extends TieredItem {
    public static final ResourceLocation ATTACK_DAMAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"club_attack_damage");
    public static final ResourceLocation ATTACK_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"club_attack_speed");
    public static final ResourceLocation ATTACK_KNOCKBACK_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"club_attack_knockback");
    public static final ResourceLocation MOVE_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)"club_move_speed");
    public static final double ATTACK_KNOCKBACK_AMOUNT = 1.5;
    protected final Multimap<Holder<Attribute>, AttributeModifier> attributeModifiers;

    public ClubItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
        double attackDamage = 5.5 + (double)tier.getAttackDamageBonus();
        double attackSpeed = -3.5;
        double moveSpeed = -0.1;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ATTACK_DAMAGE_ID, attackDamage, AttributeModifier.Operation.ADD_VALUE));
        builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ATTACK_SPEED_ID, -3.5, AttributeModifier.Operation.ADD_VALUE));
        builder.put((Object)Attributes.ATTACK_KNOCKBACK, (Object)new AttributeModifier(ATTACK_KNOCKBACK_ID, 1.5, AttributeModifier.Operation.ADD_VALUE));
        builder.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(MOVE_SPEED_ID, -0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        this.attributeModifiers = builder.build();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.getDestroySpeed((BlockGetter)worldIn, pos) != 0.0f) {
            stack.hurtAndBreak(1, entityLiving, EquipmentSlot.MAINHAND);
        }
        return true;
    }
}

