/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GreekFantasy;
import greekfantasy.item.ThunderboltItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ConchItem
extends Item {
    public ConchItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand handIn) {
        ItemStack item = player.getItemInHand(handIn);
        if (!level.isClientSide()) {
            BlockHitResult raytrace = ThunderboltItem.raytraceFromEntity((LivingEntity)player, 32.0f, ClipContext.Fluid.SOURCE_ONLY);
            BlockPos hitPos = new BlockPos((int)raytrace.getLocation().x, (int)raytrace.getLocation().y, (int)raytrace.getLocation().z);
            if (raytrace.getType() == HitResult.Type.BLOCK) {
                BlockState hitBlock = level.getBlockState(hitPos);
                if (!hitBlock.isAir() && !(hitBlock.getBlock() instanceof BucketPickup)) {
                    hitPos = hitPos.relative(raytrace.getDirection());
                }
                hitBlock = level.getBlockState(hitPos);
                FluidState hitFluid = level.getFluidState(hitPos);
                if (hitFluid.isEmpty() || !hitFluid.isSource()) {
                    ConchItem.placeWater(level, hitBlock, hitFluid, hitPos, player, item);
                } else {
                    ConchItem.takeWater(level, hitBlock, hitFluid, hitPos, player, item);
                }
                player.getCooldowns().addCooldown((Item)this, 10);
                int damage = (Integer)GreekFantasy.CONFIG.CONCH_DURABILITY_ON_USE.get();
                if (!player.isCreative() && damage > 0) {
                    item.hurtAndBreak(1, (LivingEntity)player, handIn == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                }
                return InteractionResultHolder.success((Object)item);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)item, (boolean)level.isClientSide());
    }

    private static boolean placeWater(Level level, BlockState hitBlock, FluidState hitFluid, BlockPos hitPos, Player player, ItemStack item) {
        LiquidBlockContainer liquidBlockContainer;
        if (level.dimensionType().ultraWarm()) {
            int i = hitPos.getX();
            int j = hitPos.getY();
            int k = hitPos.getZ();
            level.playSound(player, hitPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return false;
        }
        Block block = hitBlock.getBlock();
        if (block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)level, hitPos, hitBlock, (Fluid)Fluids.WATER)) {
            liquidBlockContainer.placeLiquid((LevelAccessor)level, hitPos, hitBlock, Fluids.WATER.getSource(false));
            level.playSound(player, hitPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (!level.isClientSide() && hitBlock.canBeReplaced((Fluid)Fluids.WATER) && hitBlock.getFluidState().isEmpty()) {
            level.destroyBlock(hitPos, true);
        }
        if (!level.setBlock(hitPos, Fluids.WATER.defaultFluidState().createLegacyBlock(), 11) && !hitFluid.isSource()) {
            return false;
        }
        level.playSound(player, hitPos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    private static boolean takeWater(Level level, BlockState hitBlock, FluidState hitFluid, BlockPos hitPos, Player player, ItemStack item) {
        Block block = hitBlock.getBlock();
        if (block instanceof BucketPickup) {
            ItemStack result;
            BucketPickup bucketpickup = (BucketPickup)block;
            if (level.mayInteract(player, hitPos) && player.mayUseItemAt(hitPos, null, item) && hitFluid.is(FluidTags.WATER) && !(result = bucketpickup.pickupBlock(player, (LevelAccessor)level, hitPos, hitBlock)).isEmpty()) {
                bucketpickup.getPickupSound(hitBlock).ifPresent(sound -> player.playSound(sound, 1.0f, 1.0f));
                level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, hitPos);
                return true;
            }
        }
        return false;
    }
}

