/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.entity.misc.Discus;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class DiscusItem
extends Item {
    private static final float OPTIMAL_USE_DURATION = 25.0f;

    public DiscusItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int duration) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int useDuration = this.getUseDuration(stack, entity) - duration;
            if ((float)useDuration < 12.5f) {
                return;
            }
            if (!level.isClientSide()) {
                this.throwDiscus(level, player, stack, useDuration);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    protected void throwDiscus(Level level, Player thrower, ItemStack stack, int usedTicks) {
        Discus discus = Discus.create(level, (LivingEntity)thrower);
        float speed = 1.7f - 0.05f * Math.min(Math.abs((float)usedTicks - 25.0f), 18.75f);
        discus.shootFromRotation((Entity)thrower, thrower.getXRot(), thrower.getYRot(), 0.0f, speed, 3.5f);
        level.addFreshEntity((Entity)discus);
        if (!thrower.isCreative()) {
            stack.shrink(1);
        }
        thrower.playSound(SoundEvents.EGG_THROW, 0.6f, 0.6f + thrower.getRandom().nextFloat() * 0.2f);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")).withStyle(ChatFormatting.GRAY));
    }
}

