/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.enchantment.EnchantmentUtils;
import greekfantasy.entity.misc.DragonToothHook;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class DragonToothRodItem
extends FishingRodItem {
    public static final ResourceKey<Enchantment> FISHING_LUCK = Enchantments.LUCK_OF_THE_SEA;
    public static final int FISHING_LUCK_LEVEL = 3;

    public DragonToothRodItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        if (player.fishing != null) {
            if (!level.isClientSide) {
                int i = player.fishing.retrieve(itemstack);
                itemstack.hurtAndBreak(i, (LivingEntity)player, interactionHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            }
            level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
        } else {
            level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide) {
                int k = EnchantmentUtils.getEnchantmentLevel(level, (ResourceKey<Enchantment>)Enchantments.LURE, itemstack);
                int j = EnchantmentUtils.getEnchantmentLevel(level, (ResourceKey<Enchantment>)Enchantments.LUCK_OF_THE_SEA, itemstack);
                level.addFreshEntity((Entity)new DragonToothHook(player, level, j, k));
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        if (EnchantmentUtils.getEnchantmentLevel(level, FISHING_LUCK, stack) < 3) {
            EnchantmentUtils.enchant(level, stack, FISHING_LUCK, 3);
        }
    }

    public void onCraftedBy(ItemStack stack, Level level, Player playerIn) {
        if (EnchantmentUtils.getEnchantmentLevel(level, FISHING_LUCK, stack) < 3) {
            EnchantmentUtils.enchant(level, stack, FISHING_LUCK, 3);
        }
    }

    public boolean isFoil(ItemStack stack) {
        return stack.isEnchanted();
    }
}

