/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GreekFantasy;
import greekfantasy.enchantment.EnchantmentUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public abstract class EnchantedBowItem
extends BowItem {
    public EnchantedBowItem(Item.Properties builder) {
        super(builder);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            boolean doNotConsume = player.getAbilities().instabuild || stack.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.INFINITY)) > 0;
            ItemStack ammo = player.getProjectile(stack);
            int useDuration = this.getUseDuration(stack, entityLiving) - timeLeft;
            if ((useDuration = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)useDuration, (!ammo.isEmpty() || doNotConsume ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammo.isEmpty() || doNotConsume) {
                float power;
                if (ammo.isEmpty()) {
                    ammo = new ItemStack((ItemLike)Items.ARROW);
                }
                if (!((double)(power = EnchantedBowItem.getPowerForTime((int)useDuration)) < 0.1)) {
                    ArrowItem arrowItem;
                    Item item;
                    boolean isInfinite;
                    boolean bl = isInfinite = player.getAbilities().instabuild || (item = ammo.getItem()) instanceof ArrowItem && (arrowItem = (ArrowItem)item).isInfinite(ammo, stack, (LivingEntity)player);
                    if (!level.isClientSide()) {
                        this.shootArrow(level, stack, ammo, power, 1.0f, isInfinite, player);
                        int arrowCount = this.getArrowCount(stack);
                        for (int i = 1; i < arrowCount; ++i) {
                            this.shootArrow(level, stack, ammo, power, 8.0f, true, player);
                        }
                        int damage = this.getDamageOnUse(stack);
                        if (damage > 0) {
                            stack.hurtAndBreak(damage, (LivingEntity)player, player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                        }
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + power * 0.5f);
                    if (!isInfinite && !player.getAbilities().instabuild) {
                        ammo.shrink(1);
                        if (ammo.isEmpty()) {
                            player.getInventory().removeItem(ammo);
                        }
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }
    }

    protected AbstractArrow shootArrow(Level level, ItemStack itemStack, ItemStack ammo, float power, float inaccuracy, boolean creativePickup, Player player) {
        int powerEnchant;
        ArrowItem arrowitem = (ArrowItem)(ammo.getItem() instanceof ArrowItem ? ammo.getItem() : Items.ARROW);
        AbstractArrow arrow = arrowitem.createArrow(level, ammo, (LivingEntity)player, itemStack);
        arrow = this.customArrow(arrow, itemStack, ammo);
        float velocity = power * 3.0f * this.getArrowVelocityMultiplier();
        arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, velocity, inaccuracy);
        if (power >= 1.0f) {
            arrow.setCritArrow(true);
        }
        if ((powerEnchant = itemStack.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.POWER))) > 0) {
            arrow.setBaseDamage(arrow.getBaseDamage() + (double)powerEnchant * 0.5 + 0.5);
        }
        int punchEnchant = itemStack.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PUNCH));
        if (itemStack.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FLAME)) > 0) {
            arrow.igniteForSeconds(100.0f);
        }
        if (creativePickup || player.getAbilities().instabuild && (ammo.is(Items.SPECTRAL_ARROW) || ammo.is(Items.TIPPED_ARROW))) {
            arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        level.addFreshEntity((Entity)arrow);
        return arrow;
    }

    protected abstract int getBaseEnchantmentCount();

    protected float getArrowVelocityMultiplier() {
        return 1.0f;
    }

    protected int getArrowCount(ItemStack stack) {
        return 1;
    }

    protected int getDamageOnUse(ItemStack stack) {
        return 1;
    }

    public void onCraftedBy(ItemStack stack, Level level, Player playerIn) {
        this.checkAndApplyBaseEnchantments(stack, level);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.isEnchanted();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        this.checkAndApplyBaseEnchantments(stack, level);
    }

    public abstract void checkAndApplyBaseEnchantments(ItemStack var1, Level var2);

    public static class ApolloBowItem
    extends EnchantedBowItem {
        public ApolloBowItem(Item.Properties builder) {
            super(builder);
        }

        @Override
        public void checkAndApplyBaseEnchantments(ItemStack stack, Level level) {
            if (stack.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FLAME)) < 1) {
                EnchantmentUtils.enchant(level, stack, (ResourceKey<Enchantment>)Enchantments.FLAME, 1);
            }
        }

        @Override
        protected int getBaseEnchantmentCount() {
            return 1;
        }

        @Override
        protected float getArrowVelocityMultiplier() {
            return 1.5f;
        }

        @Override
        protected int getArrowCount(ItemStack stack) {
            return 2;
        }

        @Override
        protected int getDamageOnUse(ItemStack stack) {
            return (Integer)GreekFantasy.CONFIG.APOLLO_BOW_DURABILITY_ON_USE.get();
        }

        public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
            arrow.setBaseDamage(arrow.getBaseDamage() * 1.75);
            return arrow;
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            list.add((Component)Component.translatable((String)"enchantment.minecraft.multishot").withStyle(ChatFormatting.AQUA).append(" ").append((Component)Component.translatable((String)"enchantment.level.1").withStyle(ChatFormatting.AQUA)));
        }
    }

    public static class ArtemisBowItem
    extends EnchantedBowItem {
        public ArtemisBowItem(Item.Properties builder) {
            super(builder);
        }

        @Override
        public void checkAndApplyBaseEnchantments(ItemStack stack, Level level) {
            if (stack.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.POWER)) < 5) {
                EnchantmentUtils.enchant(level, stack, (ResourceKey<Enchantment>)Enchantments.POWER, 5);
            }
        }

        @Override
        protected int getBaseEnchantmentCount() {
            return 1;
        }

        @Override
        protected float getArrowVelocityMultiplier() {
            return 1.25f;
        }

        @Override
        protected int getArrowCount(ItemStack stack) {
            return 3;
        }

        @Override
        protected int getDamageOnUse(ItemStack stack) {
            return (Integer)GreekFantasy.CONFIG.ARTEMIS_BOW_DURABILITY_ON_USE.get();
        }

        public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
            arrow.setBaseDamage(arrow.getBaseDamage() * 1.25);
            return arrow;
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            list.add((Component)Component.translatable((String)"enchantment.minecraft.multishot").withStyle(ChatFormatting.AQUA).append(" ").append((Component)Component.translatable((String)"enchantment.level.2").withStyle(ChatFormatting.AQUA)));
        }
    }

    public static class AvernalBowItem
    extends EnchantedBowItem {
        public AvernalBowItem(Item.Properties builder) {
            super(builder);
        }

        @Override
        public void checkAndApplyBaseEnchantments(ItemStack stack, Level level) {
            if (stack.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FLAME)) < 1) {
                EnchantmentUtils.enchant(level, stack, (ResourceKey<Enchantment>)Enchantments.FLAME, 1);
            }
            if (stack.getEnchantmentLevel((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.VANISHING_CURSE)) < 1) {
                EnchantmentUtils.enchant(level, stack, (ResourceKey<Enchantment>)Enchantments.VANISHING_CURSE, 1);
            }
        }

        @Override
        protected int getBaseEnchantmentCount() {
            return 2;
        }

        @Override
        protected float getArrowVelocityMultiplier() {
            return 1.0f;
        }

        @Override
        protected int getDamageOnUse(ItemStack stack) {
            return (Integer)GreekFantasy.CONFIG.AVERNAL_BOW_DURABILITY_ON_USE.get();
        }
    }
}

