/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GFRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class GFArmorMaterials {
    private static final ResourceLocation COPPER_INGOTS = ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"ingots/copper");
    public static final Holder<ArmorMaterial> HELLENIC = GFArmorMaterials.createMaterial("hellenic", Map.of(ArmorItem.Type.HELMET, 2, ArmorItem.Type.CHESTPLATE, 5, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.BOOTS, 2), 18, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, 0.0f, 0.0f, () -> Ingredient.of((TagKey)TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)COPPER_INGOTS)));
    public static final Holder<ArmorMaterial> SNAKESKIN = GFArmorMaterials.createMaterial("snakeskin", Map.of(ArmorItem.Type.HELMET, 1, ArmorItem.Type.CHESTPLATE, 4, ArmorItem.Type.LEGGINGS, 5, ArmorItem.Type.BOOTS, 2), 15, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 0.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)GFRegistry.ItemReg.TOUGH_SNAKESKIN.get()}));
    public static final Holder<ArmorMaterial> AVERNAL = GFArmorMaterials.createMaterial("avernal", Map.of(ArmorItem.Type.HELMET, 2, ArmorItem.Type.CHESTPLATE, 5, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.BOOTS, 2), 11, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, 1.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)GFRegistry.ItemReg.AVERNAL_SHARD.get()}));
    public static final Holder<ArmorMaterial> NEMEAN = GFArmorMaterials.createMaterial("nemean", Map.of(ArmorItem.Type.HELMET, 2, ArmorItem.Type.CHESTPLATE, 5, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.BOOTS, 3), 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 2.0f, 0.0f, () -> Ingredient.EMPTY);
    public static final Holder<ArmorMaterial> WINGED = GFArmorMaterials.createMaterial("winged", Map.of(ArmorItem.Type.HELMET, 2, ArmorItem.Type.CHESTPLATE, 5, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.BOOTS, 2), 22, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, 1.0f, -0.05f, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)GFRegistry.ItemReg.AVERNAL_FEATHER.get()}));

    private static Holder<ArmorMaterial> createMaterial(String textureName, Map<ArmorItem.Type, Integer> defense, int enchantmentValue, Holder<SoundEvent> sound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        return BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)new ArmorMaterial(defense, enchantmentValue, sound, repairIngredient, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"greekfantasy", (String)textureName))), toughness, knockbackResistance));
    }
}

