/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import greekfantasy.GFRegistry;
import greekfantasy.block.GoldenStringBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GoldenBallItem
extends Item {
    public GoldenBallItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof LivingEntity) {
                boolean mainhand;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.tickCount % 4 == 0 && !level.isOutsideBuildHeight(livingEntity.blockPosition()) && ((mainhand = livingEntity.getMainHandItem().getItem() == this) || livingEntity.getOffhandItem().getItem() == this) && serverLevel.structureManager().hasAnyStructureAt(entity.blockPosition())) {
                    InteractionHand hand = mainhand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                    BlockPos pos = livingEntity.blockPosition();
                    BlockState current = level.getBlockState(pos);
                    BlockState string = ((Block)GFRegistry.BlockReg.GOLDEN_STRING.get()).defaultBlockState();
                    boolean isString = current.is((Block)GFRegistry.BlockReg.GOLDEN_STRING.get());
                    if (isString && (Integer)current.getValue((Property)GoldenStringBlock.AGE) > 0) {
                        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                    } else if (!isString && current.is(BlockTags.REPLACEABLE) && string.canSurvive((LevelReader)level, pos)) {
                        level.setBlock(pos, string, 3);
                        livingEntity.getItemInHand(hand).hurtAndBreak(1, livingEntity, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    }
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack);
    }
}

