/*
 * Decompiled with CFR 0.152.
 */
package greekfantasy.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class GorgonBloodItem
extends Item {
    public static final FoodProperties GORGON_BLOOD_GOOD = new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.REGENERATION, 180), 1.0f).build();
    public static final FoodProperties GORGON_BLOOD_BAD = new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.POISON, 180), 1.0f).build();

    public GorgonBloodItem(Item.Properties properties) {
        super(properties);
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        return Math.random() < 0.5 ? GORGON_BLOOD_BAD : GORGON_BLOOD_GOOD;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getEatingSound() {
        return this.getDrinkingSound();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return super.use(level, player, hand);
    }

    public ItemStack finishUsingItem(ItemStack item, Level level, LivingEntity entity) {
        Player player;
        ItemStack container = item.getCraftingRemainingItem();
        ItemStack result = super.finishUsingItem(item, level, entity);
        if (result.isEmpty()) {
            return container;
        }
        if (entity instanceof Player && !(player = (Player)entity).isCreative()) {
            player.getInventory().add(container);
        }
        entity.gameEvent((Holder)GameEvent.DRINK);
        return result;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.heal")).withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.poison")).withStyle(ChatFormatting.RED));
    }
}

